/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice.Secure;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class SecureBuilder {
    private String _keystoreId;
    Map<Class<? extends Augmentation<Secure>>, Augmentation<Secure>> augmentation = Collections.emptyMap();

    public SecureBuilder() {
    }

    public SecureBuilder(Secure base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Secure>>, Augmentation<Secure>>(aug);
        }
        this._keystoreId = base.getKeystoreId();
    }

    public String getKeystoreId() {
        return this._keystoreId;
    }

    public <E$$ extends Augmentation<Secure>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public SecureBuilder setKeystoreId(String value) {
        this._keystoreId = value;
        return this;
    }

    public SecureBuilder addAugmentation(Augmentation<Secure> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Secure>>, Augmentation<Secure>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SecureBuilder removeAugmentation(Class<? extends Augmentation<Secure>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Secure build() {
        return new SecureImpl(this);
    }

    private static final class SecureImpl
    extends AbstractAugmentable<Secure>
    implements Secure {
        private final String _keystoreId;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SecureImpl(SecureBuilder base) {
            super(base.augmentation);
            this._keystoreId = base.getKeystoreId();
        }

        @Override
        public String getKeystoreId() {
            return this._keystoreId;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Secure.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Secure.bindingEquals(this, obj);
        }

        public String toString() {
            return Secure.bindingToString(this);
        }
    }
}

