/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Credentials;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Security;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ConnectionParameters;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.SecurityChoice;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConnectionParametersBuilder {
    private org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials.Credentials _credentials;
    private Host _host;
    private PortNumber _port;
    private SecurityChoice _securityChoice;
    Map<Class<? extends Augmentation<ConnectionParameters>>, Augmentation<ConnectionParameters>> augmentation = Collections.emptyMap();

    public ConnectionParametersBuilder() {
    }

    public ConnectionParametersBuilder(Security arg) {
        this._securityChoice = arg.getSecurityChoice();
        this._credentials = arg.getCredentials();
    }

    public ConnectionParametersBuilder(Credentials arg) {
        this._credentials = arg.getCredentials();
    }

    public ConnectionParametersBuilder(ConnectionParameters base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ConnectionParameters>>, Augmentation<ConnectionParameters>>(aug);
        }
        this._credentials = base.getCredentials();
        this._host = base.getHost();
        this._port = base.getPort();
        this._securityChoice = base.getSecurityChoice();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Credentials) {
            this._credentials = ((Credentials)arg).getCredentials();
            isValidArg = true;
        }
        if (arg instanceof Security) {
            this._securityChoice = ((Security)arg).getSecurityChoice();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Credentials, Security]");
    }

    public org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials.Credentials getCredentials() {
        return this._credentials;
    }

    public Host getHost() {
        return this._host;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public SecurityChoice getSecurityChoice() {
        return this._securityChoice;
    }

    public <E$$ extends Augmentation<ConnectionParameters>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConnectionParametersBuilder setCredentials(org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials.Credentials value) {
        this._credentials = value;
        return this;
    }

    public ConnectionParametersBuilder setHost(Host value) {
        this._host = value;
        return this;
    }

    public ConnectionParametersBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public ConnectionParametersBuilder setSecurityChoice(SecurityChoice value) {
        this._securityChoice = value;
        return this;
    }

    public ConnectionParametersBuilder addAugmentation(Augmentation<ConnectionParameters> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ConnectionParameters>>, Augmentation<ConnectionParameters>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ConnectionParametersBuilder removeAugmentation(Class<? extends Augmentation<ConnectionParameters>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ConnectionParameters build() {
        return new ConnectionParametersImpl(this);
    }

    private static final class ConnectionParametersImpl
    extends AbstractAugmentable<ConnectionParameters>
    implements ConnectionParameters {
        private final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials.Credentials _credentials;
        private final Host _host;
        private final PortNumber _port;
        private final SecurityChoice _securityChoice;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConnectionParametersImpl(ConnectionParametersBuilder base) {
            super(base.augmentation);
            this._credentials = base.getCredentials();
            this._host = base.getHost();
            this._port = base.getPort();
            this._securityChoice = base.getSecurityChoice();
        }

        @Override
        public org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials.Credentials getCredentials() {
            return this._credentials;
        }

        @Override
        public Host getHost() {
            return this._host;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        @Override
        public SecurityChoice getSecurityChoice() {
            return this._securityChoice;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = ConnectionParameters.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return ConnectionParameters.bindingEquals(this, obj);
        }

        public String toString() {
            return ConnectionParameters.bindingToString(this);
        }
    }
}

