package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.node.state.AvailableCapabilities;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link NodeState} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NodeState createNodeState(int fooXyzzy, int barBaz) {
 *         return new NodeStateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NodeState, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NodeState
 *
 */
@Generated("mdsal-binding-generator")
public class NodeStateBuilder {

    private AvailableCapabilities _availableCapabilities;
    private String _failureDetails;
    private NodeState.NodeStatus _nodeStatus;


    Map<Class<? extends Augmentation<NodeState>>, Augmentation<NodeState>> augmentation = Collections.emptyMap();

    public NodeStateBuilder() {
    }
    
    

    public NodeStateBuilder(NodeState base) {
        Map<Class<? extends Augmentation<NodeState>>, Augmentation<NodeState>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._availableCapabilities = base.getAvailableCapabilities();
        this._failureDetails = base.getFailureDetails();
        this._nodeStatus = base.getNodeStatus();
    }


    public AvailableCapabilities getAvailableCapabilities() {
        return _availableCapabilities;
    }
    
    public String getFailureDetails() {
        return _failureDetails;
    }
    
    public NodeState.NodeStatus getNodeStatus() {
        return _nodeStatus;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NodeState>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NodeStateBuilder setAvailableCapabilities(final AvailableCapabilities value) {
        this._availableCapabilities = value;
        return this;
    }
    
    public NodeStateBuilder setFailureDetails(final String value) {
        this._failureDetails = value;
        return this;
    }
    
    public NodeStateBuilder setNodeStatus(final NodeState.NodeStatus value) {
        this._nodeStatus = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NodeStateBuilder addAugmentation(Augmentation<NodeState> augmentation) {
        Class<? extends Augmentation<NodeState>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NodeStateBuilder removeAugmentation(Class<? extends Augmentation<NodeState>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link NodeState} instance.
     *
     * @return A new {@link NodeState} instance.
     */
    public NodeState build() {
        return new NodeStateImpl(this);
    }

    private static final class NodeStateImpl
        extends AbstractAugmentable<NodeState>
        implements NodeState {
    
        private final AvailableCapabilities _availableCapabilities;
        private final String _failureDetails;
        private final NodeState.NodeStatus _nodeStatus;
    
        NodeStateImpl(NodeStateBuilder base) {
            super(base.augmentation);
            this._availableCapabilities = base.getAvailableCapabilities();
            this._failureDetails = base.getFailureDetails();
            this._nodeStatus = base.getNodeStatus();
        }
    
        @Override
        public AvailableCapabilities getAvailableCapabilities() {
            return _availableCapabilities;
        }
        
        @Override
        public String getFailureDetails() {
            return _failureDetails;
        }
        
        @Override
        public NodeState.NodeStatus getNodeStatus() {
            return _nodeStatus;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NodeState.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NodeState.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NodeState.bindingToString(this);
        }
    }
}
