package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.SecurityChoice;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Security group of statements are available for session security and 
 * authentication. The session between the client and target MUST be encrypted 
 * using TLS. For DEBUG reasons is available connection type insecure-debug-only.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-topology</b>
 * <pre>
 * grouping security {
 *   uses credentials;
 *   choice security-choice {
 *     case secure {
 *       leaf keystore-id {
 *         type string;
 *       }
 *     }
 *     case insecure-debug-only {
 *       leaf connection-type {
 *         type enumeration {
 *           enum PLAINTEXT;
 *           enum INSECURE;
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface Security
    extends
    DataObject,
    Credentials
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("security");

    @Override
    Class<? extends Security> implementedInterface();
    
    /**
     * Return securityChoice, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Default model behavior is a secure case and required keystore-id. If is required
     *         to use one of the insecure options, then must be defined in request.
     *     </code>
     * </pre>
     *
     * @return {@code SecurityChoice} securityChoice, or {@code null} if it is not present.
     *
     */
    SecurityChoice getSecurityChoice();

}

