package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ConnectionParameters;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ExtensionsParameters;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-topology</b>
 * <pre>
 * grouping gnmi-connection-parameters {
 *   container connection-parameters {
 *     leaf host {
 *       type inet:host;
 *     }
 *     leaf port {
 *       type inet:port-number;
 *     }
 *     uses security;
 *   }
 *   container extensions-parameters {
 *     container gnmi-parameters {
 *       leaf overwrite-data-type {
 *         type enumeration {
 *           enum ALL;
 *           enum CONFIG;
 *           enum STATE;
 *           enum OPERATIONAL;
 *           enum UNRECOGNIZED;
 *           enum NONE;
 *         }
 *       }
 *       leaf use-model-name-prefix {
 *         type boolean;
 *         default false;
 *       }
 *       leaf path-target {
 *         type string;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface GnmiConnectionParameters
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("gnmi-connection-parameters");

    @Override
    Class<? extends GnmiConnectionParameters> implementedInterface();
    
    /**
     * Return connectionParameters, or {@code null} if it is not present.
     *
     * @return {@code ConnectionParameters} connectionParameters, or {@code null} if it is not present.
     *
     */
    ConnectionParameters getConnectionParameters();
    
    /**
     * Return extensionsParameters, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Defines a set of extensions parameters which can be optionally included with the
     *         request and response messages of gNMI RPCs. Allows registration of extensions
     *         defined outside of this package.
     *     </code>
     * </pre>
     *
     * @return {@code ExtensionsParameters} extensionsParameters, or {@code null} if it is not present.
     *
     */
    ExtensionsParameters getExtensionsParameters();

}

