package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.SecurityChoice;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-topology</b>
 * <pre>
 * case secure {
 *   leaf keystore-id {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>gnmi-topologysecuritysecurity-choicesecure</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface Secure
    extends
    DataObject,
    SecurityChoice,
    Augmentable<Secure>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("secure");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice.Secure> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice.Secure.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice.@NonNull Secure obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getKeystoreId());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice.@NonNull Secure thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice.Secure other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice.Secure.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getKeystoreId(), other.getKeystoreId())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice.@NonNull Secure obj) {
        final var helper = MoreObjects.toStringHelper("Secure");
        CodeHelpers.appendValue(helper, "keystoreId", obj.getKeystoreId());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return keystoreId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Identifier to keystore. Keystore is defined in gnmi-certificate-storage model.
     *     </code>
     * </pre>
     *
     * @return {@code String} keystoreId, or {@code null} if it is not present.
     *
     */
    String getKeystoreId();
    
    /**
     * Return keystoreId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Identifier to keystore. Keystore is defined in gnmi-certificate-storage model.
     *     </code>
     * </pre>
     *
     * @return {@code String} keystoreId, guaranteed to be non-null.
     * @throws NoSuchElementException if keystoreId is not present
     *
     */
    default @NonNull String requireKeystoreId() {
        return CodeHelpers.require(getKeystoreId(), "keystoreid");
    }

}

