package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.GnmiConnectionParameters;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Security;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-topology</b>
 * <pre>
 * container connection-parameters {
 *   leaf host {
 *     type inet:host;
 *   }
 *   leaf port {
 *     type inet:port-number;
 *   }
 *   uses security;
 * }
 * </pre>The schema path to identify an instance is
 * <i>gnmi-topologygnmi-connection-parametersconnection-parameters</i>
 *
 * <p>To create instances of this class use {@link ConnectionParametersBuilder}.
 * @see ConnectionParametersBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface ConnectionParameters
    extends
    ChildOf<GnmiConnectionParameters>,
    Augmentable<ConnectionParameters>,
    Security
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("connection-parameters");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ConnectionParameters> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ConnectionParameters.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.@NonNull ConnectionParameters obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getCredentials());
        result = prime * result + Objects.hashCode(obj.getHost());
        result = prime * result + Objects.hashCode(obj.getPort());
        result = prime * result + Objects.hashCode(obj.getSecurityChoice());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.@NonNull ConnectionParameters thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ConnectionParameters other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ConnectionParameters.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getPort(), other.getPort())) {
            return false;
        }
        if (!Objects.equals(thisObj.getCredentials(), other.getCredentials())) {
            return false;
        }
        if (!Objects.equals(thisObj.getHost(), other.getHost())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSecurityChoice(), other.getSecurityChoice())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.@NonNull ConnectionParameters obj) {
        final var helper = MoreObjects.toStringHelper("ConnectionParameters");
        CodeHelpers.appendValue(helper, "credentials", obj.getCredentials());
        CodeHelpers.appendValue(helper, "host", obj.getHost());
        CodeHelpers.appendValue(helper, "port", obj.getPort());
        CodeHelpers.appendValue(helper, "securityChoice", obj.getSecurityChoice());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return host, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         IP address or hostname of the target
     *     </code>
     * </pre>
     *
     * @return {@code Host} host, or {@code null} if it is not present.
     *
     */
    Host getHost();
    
    /**
     * Return host, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         IP address or hostname of the target
     *     </code>
     * </pre>
     *
     * @return {@code Host} host, guaranteed to be non-null.
     * @throws NoSuchElementException if host is not present
     *
     */
    default @NonNull Host requireHost() {
        return CodeHelpers.require(getHost(), "host");
    }
    
    /**
     * Return port, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The port number on which to contact the target
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} port, or {@code null} if it is not present.
     *
     */
    PortNumber getPort();
    
    /**
     * Return port, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The port number on which to contact the target
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} port, guaranteed to be non-null.
     * @throws NoSuchElementException if port is not present
     *
     */
    default @NonNull PortNumber requirePort() {
        return CodeHelpers.require(getPort(), "port");
    }

}

