package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.GnmiNodeState;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.node.state.AvailableCapabilities;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-topology</b>
 * <pre>
 * container node-state {
 *   leaf node-status {
 *     config false;
 *     type enumeration {
 *       enum READY;
 *       enum CONNECTING;
 *       enum TRANSIENT_FAILURE;
 *       enum IDLE;
 *       enum SHUTDOWN;
 *       enum FAILURE;
 *     }
 *   }
 *   leaf failure-details {
 *     when "../node-status='FAILURE'";
 *     config false;
 *     type string;
 *   }
 *   container available-capabilities {
 *     config false;
 *     list available-capability {
 *       leaf capability {
 *         type string;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>gnmi-topologygnmi-node-statenode-state</i>
 *
 * <p>To create instances of this class use {@link NodeStateBuilder}.
 * @see NodeStateBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface NodeState
    extends
    ChildOf<GnmiNodeState>,
    Augmentable<NodeState>
{


    @Generated("mdsal-binding-generator")
    public enum NodeStatus implements Enumeration {
        READY(0, "READY"),
        
        CONNECTING(1, "CONNECTING"),
        
        TRANSIENTFAILURE(2, "TRANSIENT_FAILURE"),
        
        IDLE(3, "IDLE"),
        
        SHUTDOWN(4, "SHUTDOWN"),
        
        FAILURE(5, "FAILURE")
        ;
    
        private static final Map<String, NodeStatus> NAME_MAP;
        private static final Map<Integer, NodeStatus> VALUE_MAP;
    
        static {
            final Builder<String, NodeStatus> nb = ImmutableMap.builder();
            final Builder<Integer, NodeStatus> vb = ImmutableMap.builder();
            for (NodeStatus enumItem : NodeStatus.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private NodeStatus(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding NodeStatus item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<NodeStatus> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding NodeStatus item, or null if no such item exists
         */
        public static NodeStatus forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("node-state");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.NodeState> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.NodeState.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.@NonNull NodeState obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAvailableCapabilities());
        result = prime * result + Objects.hashCode(obj.getFailureDetails());
        result = prime * result + Objects.hashCode(obj.getNodeStatus());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.@NonNull NodeState thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.NodeState other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.NodeState.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getFailureDetails(), other.getFailureDetails())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAvailableCapabilities(), other.getAvailableCapabilities())) {
            return false;
        }
        if (!Objects.equals(thisObj.getNodeStatus(), other.getNodeStatus())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.@NonNull NodeState obj) {
        final var helper = MoreObjects.toStringHelper("NodeState");
        CodeHelpers.appendValue(helper, "availableCapabilities", obj.getAvailableCapabilities());
        CodeHelpers.appendValue(helper, "failureDetails", obj.getFailureDetails());
        CodeHelpers.appendValue(helper, "nodeStatus", obj.getNodeStatus());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return nodeStatus, or {@code null} if it is not present.
     *
     * @return {@code NodeStatus} nodeStatus, or {@code null} if it is not present.
     *
     */
    NodeStatus getNodeStatus();
    
    /**
     * Return nodeStatus, guaranteed to be non-null.
     *
     * @return {@code NodeStatus} nodeStatus, guaranteed to be non-null.
     * @throws NoSuchElementException if nodeStatus is not present
     *
     */
    default @NonNull NodeStatus requireNodeStatus() {
        return CodeHelpers.require(getNodeStatus(), "nodestatus");
    }
    
    /**
     * Return failureDetails, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Details about the reason for the connection failure. The failure-details field
     *         is associated only with FAILURE node-status.
     *     </code>
     * </pre>
     *
     * @return {@code String} failureDetails, or {@code null} if it is not present.
     *
     */
    String getFailureDetails();
    
    /**
     * Return failureDetails, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Details about the reason for the connection failure. The failure-details field
     *         is associated only with FAILURE node-status.
     *     </code>
     * </pre>
     *
     * @return {@code String} failureDetails, guaranteed to be non-null.
     * @throws NoSuchElementException if failureDetails is not present
     *
     */
    default @NonNull String requireFailureDetails() {
        return CodeHelpers.require(getFailureDetails(), "failuredetails");
    }
    
    /**
     * Return availableCapabilities, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Resulting capabilities of the gNMI device based on supported_models field
     *         contained in CapabilityResponse which are used for constructing schema context
     *         for device's mount point.
     *     </code>
     * </pre>
     *
     * @return {@code AvailableCapabilities} availableCapabilities, or {@code null} if it is not present.
     *
     */
    AvailableCapabilities getAvailableCapabilities();

}

