package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.topology.types.GnmiTopology;
import org.opendaylight.yangtools.concepts.Builder;

/**
 * Class that builds {@link GnmiTopologyTypes} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     GnmiTopologyTypes createGnmiTopologyTypes(int fooXyzzy, int barBaz) {
 *         return new GnmiTopologyTypesBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of GnmiTopologyTypes, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see GnmiTopologyTypes
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class GnmiTopologyTypesBuilder implements Builder<GnmiTopologyTypes> {

    private GnmiTopology _gnmiTopology;



    public GnmiTopologyTypesBuilder() {
    }
    

    public GnmiTopologyTypesBuilder(GnmiTopologyTypes base) {
        this._gnmiTopology = base.getGnmiTopology();
    }


    public GnmiTopology getGnmiTopology() {
        return _gnmiTopology;
    }

    
    public GnmiTopologyTypesBuilder setGnmiTopology(final GnmiTopology value) {
        this._gnmiTopology = value;
        return this;
    }
    

    @Override
    public GnmiTopologyTypes build() {
        return new GnmiTopologyTypesImpl(this);
    }

    private static final class GnmiTopologyTypesImpl
        implements GnmiTopologyTypes {
    
        private final GnmiTopology _gnmiTopology;
    
        GnmiTopologyTypesImpl(GnmiTopologyTypesBuilder base) {
            this._gnmiTopology = base.getGnmiTopology();
        }
    
        @Override
        public GnmiTopology getGnmiTopology() {
            return _gnmiTopology;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = GnmiTopologyTypes.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return GnmiTopologyTypes.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return GnmiTopologyTypes.bindingToString(this);
        }
    }
}
