package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.SecurityChoice;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The insecure connection is available only for DEBUG reasons. For establish gRPC 
 * connection without TLS choose insecure connection type PLAINTEXT. INSECURE 
 * connection type indicates that the target should skip the signature 
 * steps, in case a secure connection is used
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-topology</b>
 * <pre>
 * case insecure-debug-only {
 *   leaf connection-type {
 *     type enumeration {
 *       enum PLAINTEXT;
 *       enum INSECURE;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>gnmi-topologysecuritysecurity-choiceinsecure-debug-only</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface InsecureDebugOnly
    extends
    DataObject,
    SecurityChoice,
    Augmentable<InsecureDebugOnly>
{


    @Generated("mdsal-binding-generator")
    public enum ConnectionType implements Enumeration {
        PLAINTEXT(0, "PLAINTEXT"),
        
        INSECURE(1, "INSECURE")
        ;
    
        private static final Map<String, ConnectionType> NAME_MAP;
        private static final Map<Integer, ConnectionType> VALUE_MAP;
    
        static {
            final Builder<String, ConnectionType> nb = ImmutableMap.builder();
            final Builder<Integer, ConnectionType> vb = ImmutableMap.builder();
            for (ConnectionType enumItem : ConnectionType.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private ConnectionType(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding ConnectionType item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<ConnectionType> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding ConnectionType item, or null if no such item exists
         */
        public static ConnectionType forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("insecure-debug-only");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice.InsecureDebugOnly> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice.InsecureDebugOnly.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice.@NonNull InsecureDebugOnly obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getConnectionType());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice.@NonNull InsecureDebugOnly thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice.InsecureDebugOnly other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice.InsecureDebugOnly.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getConnectionType(), other.getConnectionType())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.security.choice.@NonNull InsecureDebugOnly obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("InsecureDebugOnly");
        CodeHelpers.appendValue(helper, "connectionType", obj.getConnectionType());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return connectionType, or {@code null} if it is not present.
     *
     * @return {@code ConnectionType} connectionType, or {@code null} if it is not present.
     *
     */
    ConnectionType getConnectionType();
    
    /**
     * Return connectionType, guaranteed to be non-null.
     *
     * @return {@code ConnectionType} connectionType, guaranteed to be non-null.
     * @throws NoSuchElementException if connectionType is not present
     *
     */
    default @NonNull ConnectionType requireConnectionType() {
        return CodeHelpers.require(getConnectionType(), "connectiontype");
    }

}

