package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.GnmiConnectionParameters;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.GnmiParameters;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Defines a set of extensions parameters which can be optionally included with 
 * request and response messages of gNMI RPCs. Allows registration of extensions 
 * defined outside of this package.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-topology</b>
 * <pre>
 * container extensions-parameters {
 *   container gnmi-parameters {
 *     leaf overwrite-data-type {
 *       type enumeration {
 *         enum ALL;
 *         enum CONFIG;
 *         enum STATE;
 *         enum OPERATIONAL;
 *         enum UNRECOGNIZED;
 *         enum NONE;
 *       }
 *     }
 *     leaf use-model-name-prefix {
 *       type boolean;
 *       default false;
 *     }
 *     leaf path-target {
 *       type string;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>gnmi-topology/gnmi-connection-parameters/extensions-parameters</i>
 *
 * <p>To create instances of this class use {@link ExtensionsParametersBuilder}.
 * @see ExtensionsParametersBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface ExtensionsParameters
    extends
    ChildOf<GnmiConnectionParameters>,
    Augmentable<ExtensionsParameters>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("extensions-parameters");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ExtensionsParameters> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ExtensionsParameters.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.@NonNull ExtensionsParameters obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getGnmiParameters());
        result = prime * result + obj.augmentations().hashCode();
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.@NonNull ExtensionsParameters thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ExtensionsParameters other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ExtensionsParameters.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getGnmiParameters(), other.getGnmiParameters())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.@NonNull ExtensionsParameters obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ExtensionsParameters");
        CodeHelpers.appendValue(helper, "gnmiParameters", obj.getGnmiParameters());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return gnmiParameters, or {@code null} if it is not present.
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.GnmiParameters} gnmiParameters, or {@code null} if it is not present.
     *
     */
    GnmiParameters getGnmiParameters();

}

