package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.security.SecurityChoice;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ConnectionParametersBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ConnectionParametersBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new ConnectionParametersBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ConnectionParametersBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ConnectionParametersBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class ConnectionParametersBuilder implements Builder<ConnectionParameters> {

    private Credentials _credentials;
    private Host _host;
    private PortNumber _port;
    private SecurityChoice _securityChoice;


    Map<Class<? extends Augmentation<ConnectionParameters>>, Augmentation<ConnectionParameters>> augmentation = Collections.emptyMap();

    public ConnectionParametersBuilder() {
    }
    
    
    
    public ConnectionParametersBuilder(org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Security arg) {
        this._securityChoice = arg.getSecurityChoice();
        this._credentials = arg.getCredentials();
    }
    public ConnectionParametersBuilder(org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Credentials arg) {
        this._credentials = arg.getCredentials();
    }

    public ConnectionParametersBuilder(ConnectionParameters base) {
        Map<Class<? extends Augmentation<ConnectionParameters>>, Augmentation<ConnectionParameters>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._credentials = base.getCredentials();
        this._host = base.getHost();
        this._port = base.getPort();
        this._securityChoice = base.getSecurityChoice();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Credentials</li>
     * <li>org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Security</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Credentials) {
            this._credentials = ((org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Credentials)arg).getCredentials();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Security) {
            this._securityChoice = ((org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Security)arg).getSecurityChoice();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Credentials, org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.Security]");
    }

    public Credentials getCredentials() {
        return _credentials;
    }
    
    public Host getHost() {
        return _host;
    }
    
    public PortNumber getPort() {
        return _port;
    }
    
    public SecurityChoice getSecurityChoice() {
        return _securityChoice;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ConnectionParameters>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public ConnectionParametersBuilder setCredentials(final Credentials value) {
        this._credentials = value;
        return this;
    }
    
    public ConnectionParametersBuilder setHost(final Host value) {
        this._host = value;
        return this;
    }
    
    public ConnectionParametersBuilder setPort(final PortNumber value) {
        this._port = value;
        return this;
    }
    
    public ConnectionParametersBuilder setSecurityChoice(final SecurityChoice value) {
        this._securityChoice = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ConnectionParametersBuilder addAugmentation(Augmentation<ConnectionParameters> augmentation) {
        Class<? extends Augmentation<ConnectionParameters>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ConnectionParametersBuilder removeAugmentation(Class<? extends Augmentation<ConnectionParameters>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ConnectionParameters build() {
        return new ConnectionParametersImpl(this);
    }

    private static final class ConnectionParametersImpl
        extends AbstractAugmentable<ConnectionParameters>
        implements ConnectionParameters {
    
        private final Credentials _credentials;
        private final Host _host;
        private final PortNumber _port;
        private final SecurityChoice _securityChoice;
    
        ConnectionParametersImpl(ConnectionParametersBuilder base) {
            super(base.augmentation);
            this._credentials = base.getCredentials();
            this._host = base.getHost();
            this._port = base.getPort();
            this._securityChoice = base.getSecurityChoice();
        }
    
        @Override
        public Credentials getCredentials() {
            return _credentials;
        }
        
        @Override
        public Host getHost() {
            return _host;
        }
        
        @Override
        public PortNumber getPort() {
            return _port;
        }
        
        @Override
        public SecurityChoice getSecurityChoice() {
            return _securityChoice;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ConnectionParameters.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ConnectionParameters.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ConnectionParameters.bindingToString(this);
        }
    }
}
