/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.GnmiNodeState;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.node.state.AvailableCapabilities;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;

public interface NodeState
extends ChildOf<GnmiNodeState>,
Augmentable<NodeState> {
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("node-state");

    default public Class<NodeState> implementedInterface() {
        return NodeState.class;
    }

    public static int bindingHashCode(@NonNull NodeState obj) {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(obj.getAvailableCapabilities());
        result = 31 * result + Objects.hashCode(obj.getFailureDetails());
        result = 31 * result + Objects.hashCode((Object)obj.getNodeStatus());
        result = 31 * result + obj.augmentations().hashCode();
        return result;
    }

    public static boolean bindingEquals(@NonNull NodeState thisObj, Object obj) {
        if (thisObj == obj) {
            return true;
        }
        NodeState other = (NodeState)CodeHelpers.checkCast(NodeState.class, (Object)obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getFailureDetails(), other.getFailureDetails())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAvailableCapabilities(), other.getAvailableCapabilities())) {
            return false;
        }
        if (!Objects.equals((Object)thisObj.getNodeStatus(), (Object)other.getNodeStatus())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }

    public static String bindingToString(@NonNull NodeState obj) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NodeState");
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"availableCapabilities", (Object)obj.getAvailableCapabilities());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"failureDetails", (Object)obj.getFailureDetails());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"nodeStatus", (Object)((Object)obj.getNodeStatus()));
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", obj.augmentations().values());
        return helper.toString();
    }

    public NodeStatus getNodeStatus();

    public String getFailureDetails();

    public AvailableCapabilities getAvailableCapabilities();

    public static enum NodeStatus implements Enumeration
    {
        READY(0, "READY"),
        CONNECTING(1, "CONNECTING"),
        TRANSIENTFAILURE(2, "TRANSIENT_FAILURE"),
        IDLE(3, "IDLE"),
        SHUTDOWN(4, "SHUTDOWN"),
        FAILURE(5, "FAILURE");

        private static final Map<String, NodeStatus> NAME_MAP;
        private static final Map<Integer, NodeStatus> VALUE_MAP;
        private final String name;
        private final int value;

        private NodeStatus(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static Optional<NodeStatus> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }

        public static NodeStatus forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }

        static {
            ImmutableMap.Builder nb = ImmutableMap.builder();
            ImmutableMap.Builder vb = ImmutableMap.builder();
            for (NodeStatus enumItem : NodeStatus.values()) {
                vb.put((Object)enumItem.value, (Object)enumItem);
                nb.put((Object)enumItem.name, (Object)enumItem);
            }
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    }
}

