/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316;

import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.GnmiConnectionParameters;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.GnmiNode;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.GnmiNodeState;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ConnectionParameters;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ExtensionsParameters;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.NodeState;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GnmiNodeBuilder
implements Builder<GnmiNode> {
    private ConnectionParameters _connectionParameters;
    private ExtensionsParameters _extensionsParameters;
    private NodeState _nodeState;

    public GnmiNodeBuilder() {
    }

    public GnmiNodeBuilder(GnmiConnectionParameters arg) {
        this._connectionParameters = arg.getConnectionParameters();
        this._extensionsParameters = arg.getExtensionsParameters();
    }

    public GnmiNodeBuilder(GnmiNodeState arg) {
        this._nodeState = arg.getNodeState();
    }

    public GnmiNodeBuilder(GnmiNode base) {
        this._connectionParameters = base.getConnectionParameters();
        this._extensionsParameters = base.getExtensionsParameters();
        this._nodeState = base.getNodeState();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof GnmiNodeState) {
            this._nodeState = ((GnmiNodeState)arg).getNodeState();
            isValidArg = true;
        }
        if (arg instanceof GnmiConnectionParameters) {
            this._connectionParameters = ((GnmiConnectionParameters)arg).getConnectionParameters();
            this._extensionsParameters = ((GnmiConnectionParameters)arg).getExtensionsParameters();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.GnmiNodeState, org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.GnmiConnectionParameters]");
    }

    public ConnectionParameters getConnectionParameters() {
        return this._connectionParameters;
    }

    public ExtensionsParameters getExtensionsParameters() {
        return this._extensionsParameters;
    }

    public NodeState getNodeState() {
        return this._nodeState;
    }

    public GnmiNodeBuilder setConnectionParameters(ConnectionParameters value) {
        this._connectionParameters = value;
        return this;
    }

    public GnmiNodeBuilder setExtensionsParameters(ExtensionsParameters value) {
        this._extensionsParameters = value;
        return this;
    }

    public GnmiNodeBuilder setNodeState(NodeState value) {
        this._nodeState = value;
        return this;
    }

    public GnmiNode build() {
        return new GnmiNodeImpl(this);
    }

    private static final class GnmiNodeImpl
    implements GnmiNode {
        private final ConnectionParameters _connectionParameters;
        private final ExtensionsParameters _extensionsParameters;
        private final NodeState _nodeState;
        private int hash = 0;
        private volatile boolean hashValid = false;

        GnmiNodeImpl(GnmiNodeBuilder base) {
            this._connectionParameters = base.getConnectionParameters();
            this._extensionsParameters = base.getExtensionsParameters();
            this._nodeState = base.getNodeState();
        }

        @Override
        public ConnectionParameters getConnectionParameters() {
            return this._connectionParameters;
        }

        @Override
        public ExtensionsParameters getExtensionsParameters() {
            return this._extensionsParameters;
        }

        @Override
        public NodeState getNodeState() {
            return this._nodeState;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = GnmiNode.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return GnmiNode.bindingEquals(this, obj);
        }

        public String toString() {
            return GnmiNode.bindingToString(this);
        }
    }
}

