package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.node.state;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.node.state.node.state.available.capabilities.AvailableCapability;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link AvailableCapabilitiesBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     AvailableCapabilitiesBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new AvailableCapabilitiesBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of AvailableCapabilitiesBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see AvailableCapabilitiesBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class AvailableCapabilitiesBuilder implements Builder<AvailableCapabilities> {

    private List<AvailableCapability> _availableCapability;


    Map<Class<? extends Augmentation<AvailableCapabilities>>, Augmentation<AvailableCapabilities>> augmentation = Collections.emptyMap();

    public AvailableCapabilitiesBuilder() {
    }
    
    

    public AvailableCapabilitiesBuilder(AvailableCapabilities base) {
        Map<Class<? extends Augmentation<AvailableCapabilities>>, Augmentation<AvailableCapabilities>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._availableCapability = base.getAvailableCapability();
    }


    public List<AvailableCapability> getAvailableCapability() {
        return _availableCapability;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<AvailableCapabilities>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public AvailableCapabilitiesBuilder setAvailableCapability(final List<AvailableCapability> values) {
        this._availableCapability = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AvailableCapabilitiesBuilder addAugmentation(Augmentation<AvailableCapabilities> augmentation) {
        Class<? extends Augmentation<AvailableCapabilities>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AvailableCapabilitiesBuilder removeAugmentation(Class<? extends Augmentation<AvailableCapabilities>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public AvailableCapabilities build() {
        return new AvailableCapabilitiesImpl(this);
    }

    private static final class AvailableCapabilitiesImpl
        extends AbstractAugmentable<AvailableCapabilities>
        implements AvailableCapabilities {
    
        private final List<AvailableCapability> _availableCapability;
    
        AvailableCapabilitiesImpl(AvailableCapabilitiesBuilder base) {
            super(base.augmentation);
            this._availableCapability = CodeHelpers.emptyToNull(base.getAvailableCapability());
        }
    
        @Override
        public List<AvailableCapability> getAvailableCapability() {
            return _availableCapability;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = AvailableCapabilities.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return AvailableCapabilities.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return AvailableCapabilities.bindingToString(this);
        }
    }
}
