package org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.ExtensionsParameters;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>gnmi-topology</b>
 * <pre>
 * container gnmi-parameters {
 *   leaf overwrite-data-type {
 *     type enumeration {
 *       enum ALL;
 *       enum CONFIG;
 *       enum STATE;
 *       enum OPERATIONAL;
 *       enum UNRECOGNIZED;
 *       enum NONE;
 *     }
 *   }
 *   leaf use-model-name-prefix {
 *     type boolean;
 *     default false;
 *   }
 *   leaf path-target {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>gnmi-topology/gnmi-connection-parameters/extensions-parameters/gnmi-parameters</i>
 *
 * <p>To create instances of this class use {@link GnmiParametersBuilder}.
 * @see GnmiParametersBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface GnmiParameters
    extends
    ChildOf<ExtensionsParameters>,
    Augmentable<GnmiParameters>
{


    @Generated("mdsal-binding-generator")
    public enum OverwriteDataType implements Enumeration {
        ALL(0, "ALL"),
        
        CONFIG(1, "CONFIG"),
        
        STATE(2, "STATE"),
        
        OPERATIONAL(3, "OPERATIONAL"),
        
        UNRECOGNIZED(4, "UNRECOGNIZED"),
        
        NONE(5, "NONE")
        ;
    
        private static final Map<String, OverwriteDataType> NAME_MAP;
        private static final Map<Integer, OverwriteDataType> VALUE_MAP;
    
        static {
            final Builder<String, OverwriteDataType> nb = ImmutableMap.builder();
            final Builder<Integer, OverwriteDataType> vb = ImmutableMap.builder();
            for (OverwriteDataType enumItem : OverwriteDataType.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private OverwriteDataType(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding OverwriteDataType item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<OverwriteDataType> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding OverwriteDataType item, or null if no such item exists
         */
        public static OverwriteDataType forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("gnmi-parameters");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.GnmiParameters> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.GnmiParameters.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.@NonNull GnmiParameters obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getOverwriteDataType());
        result = prime * result + Objects.hashCode(obj.getPathTarget());
        result = prime * result + Objects.hashCode(obj.getUseModelNamePrefix());
        result = prime * result + obj.augmentations().hashCode();
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.@NonNull GnmiParameters thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.GnmiParameters other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.GnmiParameters.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getUseModelNamePrefix(), other.getUseModelNamePrefix())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPathTarget(), other.getPathTarget())) {
            return false;
        }
        if (!Objects.equals(thisObj.getOverwriteDataType(), other.getOverwriteDataType())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.@NonNull GnmiParameters obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("GnmiParameters");
        CodeHelpers.appendValue(helper, "overwriteDataType", obj.getOverwriteDataType());
        CodeHelpers.appendValue(helper, "pathTarget", obj.getPathTarget());
        CodeHelpers.appendValue(helper, "useModelNamePrefix", obj.getUseModelNamePrefix());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return overwriteDataType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Overwrites the type field of gNMI GetRequest. If not set, the type field is
     *         automatically set to CONFIG/STATE based on the RESTCONF content query parameter.
     *         This setting is useful in cases where the device does not support GetRequest
     *         with CONFIG/STATE type field.
     *     </code>
     * </pre>
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.lighty.gnmi.topology.rev210316.gnmi.connection.parameters.extensions.parameters.GnmiParameters.OverwriteDataType} overwriteDataType, or {@code null} if it is not present.
     *
     */
    OverwriteDataType getOverwriteDataType();
    
    /**
     * Return useModelNamePrefix, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Some devices require a module prefix in first element name of gNMI request path
     *         (e.g interfaces -&amp;gt; openconfig-interfaces:interfaces). When flag
     *         use-model-name-prefix is set to true for device, YIID will be transformed into
     *         gNMI path where elements have their module name. E.g. element interfaces from
     *         module openconfig-interfaces will be transformed as
     *         openconfig-interfaces:interfaces
     *     </code>
     * </pre>
     *
     * @return {@code java.lang.Boolean} useModelNamePrefix, or {@code null} if it is not present.
     *
     */
    Boolean getUseModelNamePrefix();
    
    @Deprecated(forRemoval = true)
    default Boolean isUseModelNamePrefix() {
        return getUseModelNamePrefix();
    }
    
    /**
     * Return pathTarget, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The path-target field is used to specify the context of a particular stream of
     *         data. The data stream can be intended for individual target datastores. Only set
     *         in prefix for a path. This field MUST only ever be present on prefix paths in
     *         the corresponding request and response messages. This field is optional for
     *         clients.
     *     </code>
     * </pre>
     *
     * @return {@code java.lang.String} pathTarget, or {@code null} if it is not present.
     *
     */
    String getPathTarget();

}

