/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.applications.rnc.module.config;

import com.typesafe.config.Config;
import io.lighty.aaa.config.AAAConfiguration;
import io.lighty.aaa.util.AAAConfigUtils;
import io.lighty.applications.rnc.module.config.RncLightyModuleConfiguration;
import io.lighty.applications.util.ModulesConfig;
import io.lighty.core.controller.impl.config.ConfigurationException;
import io.lighty.core.controller.impl.config.ControllerConfiguration;
import io.lighty.core.controller.impl.util.ControllerConfigUtils;
import io.lighty.modules.northbound.restconf.community.impl.config.RestConfConfiguration;
import io.lighty.modules.northbound.restconf.community.impl.util.RestConfConfigUtils;
import io.lighty.modules.southbound.netconf.impl.config.NetconfConfiguration;
import io.lighty.modules.southbound.netconf.impl.util.NetconfConfigUtils;
import io.lighty.server.config.LightyServerConfig;
import io.lighty.server.util.LightyServerConfigUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RncLightyModuleConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RncLightyModuleConfigUtils.class);

    private RncLightyModuleConfigUtils() {
        throw new UnsupportedOperationException();
    }

    public static RncLightyModuleConfiguration loadConfigFromFile(Path configPath) throws ConfigurationException {
        ModulesConfig moduleConfig;
        AAAConfiguration aaaConfig;
        NetconfConfiguration netconfConfig;
        LightyServerConfig lightyServerConfig;
        RestConfConfiguration restconfConfig;
        ControllerConfiguration controllerConfig;
        LOG.info("Loading RNC lighty.io configuration from file {} ...", (Object)configPath);
        try {
            LOG.debug("Loading lighty.io controller module configuration from file...");
            controllerConfig = ControllerConfigUtils.getConfiguration((InputStream)Files.newInputStream(configPath, new OpenOption[0]));
            RncLightyModuleConfigUtils.addDefaultAppModels(controllerConfig);
            Config akkaConfig = controllerConfig.getActorSystemConfig().getConfig().resolve();
            controllerConfig.getActorSystemConfig().setConfig(akkaConfig);
            LOG.debug("lighty.io controller module configuration from file loaded!");
            LOG.debug("Loading lighty.io RESTCONF module configuration from file...");
            restconfConfig = RestConfConfigUtils.getRestConfConfiguration((InputStream)Files.newInputStream(configPath, new OpenOption[0]));
            LOG.debug("lighty.io RESTCONF module configuration from file loaded!");
            LOG.debug("Loading lighty.io Jetty server module configuration from file...");
            lightyServerConfig = LightyServerConfigUtils.getServerConfiguration((InputStream)Files.newInputStream(configPath, new OpenOption[0]));
            LOG.debug("lighty.io Jetty server module configuration from file loaded!");
            LOG.debug("Loading lighty.io NETCONF module configuration from file...");
            netconfConfig = NetconfConfigUtils.createNetconfConfiguration((InputStream)Files.newInputStream(configPath, new OpenOption[0]));
            LOG.debug("lighty.io NETCONF module configuration from file loaded!");
            LOG.debug("Loading lighty.io AAA module configuration from file...");
            aaaConfig = AAAConfigUtils.getAAAConfiguration((InputStream)Files.newInputStream(configPath, new OpenOption[0]));
            LOG.debug("lighty.io AAA module configuration from file loaded!");
            LOG.debug("Loading lighty.io app module configuration from file...");
            moduleConfig = ModulesConfig.getModulesConfig((InputStream)Files.newInputStream(configPath, new OpenOption[0]));
            LOG.debug("lighty.io app module configuration from file loaded!");
        }
        catch (IOException e) {
            throw new ConfigurationException("Exception thrown while loading configuration!", (Throwable)e);
        }
        return new RncLightyModuleConfiguration(controllerConfig, lightyServerConfig, restconfConfig, netconfConfig, aaaConfig, moduleConfig);
    }

    public static RncLightyModuleConfiguration loadDefaultConfig() throws ConfigurationException {
        LOG.info("Loading default RNC lighty.io configuration ...");
        HashSet<YangModuleInfo> modelPaths = new HashSet<YangModuleInfo>();
        RncLightyModuleConfigUtils.defaultModels(modelPaths);
        LOG.debug("Loading default lighty.io controller module configuration...");
        ControllerConfiguration controllerConfig = ControllerConfigUtils.getDefaultSingleNodeConfiguration(modelPaths);
        LOG.debug("Default lighty.io controller module configuration!");
        LOG.debug("Loading default lighty.io RESTCONF module configuration...");
        RestConfConfiguration restConfConfiguration = RestConfConfigUtils.getDefaultRestConfConfiguration();
        LOG.debug("Default lighty.io RESTCONF module configuration loaded!");
        LOG.debug("Loading default lighty.io Jetty server module configuration...");
        LightyServerConfig lightyServerConfig = LightyServerConfigUtils.getDefaultLightyServerConfig();
        LOG.debug("Default lighty.io Jetty server module configuration loaded!");
        LOG.debug("Loading default lighty.io NETCONF module configuration...");
        NetconfConfiguration netconfConfig = NetconfConfigUtils.createDefaultNetconfConfiguration();
        LOG.debug("Default lighty.io NETCONF module configuration loaded!");
        LOG.debug("Loading default lighty.io AAA module configuration...");
        AAAConfiguration aaaConfig = AAAConfigUtils.createDefaultAAAConfiguration();
        LOG.debug("Default lighty.io AAA module configuration loaded!");
        LOG.debug("Loading default lighty.io app module configuration...");
        ModulesConfig modulesConfig = ModulesConfig.getDefaultModulesConfig();
        LOG.debug("Default lighty.io app module configuration loaded!");
        return new RncLightyModuleConfiguration(controllerConfig, lightyServerConfig, restConfConfiguration, netconfConfig, aaaConfig, modulesConfig);
    }

    private static void addDefaultAppModels(ControllerConfiguration controllerConfig) {
        LOG.debug("Adding minimal needed yang models if they are not present...");
        HashSet<YangModuleInfo> modelPaths = new HashSet<YangModuleInfo>(controllerConfig.getSchemaServiceConfig().getModels());
        RncLightyModuleConfigUtils.defaultModels(modelPaths);
        controllerConfig.getSchemaServiceConfig().setModels(Collections.unmodifiableSet(modelPaths));
    }

    private static void defaultModels(Set<YangModuleInfo> modelPaths) {
        modelPaths.addAll(RestConfConfigUtils.YANG_MODELS);
        modelPaths.addAll(NetconfConfigUtils.NETCONF_TOPOLOGY_MODELS);
        modelPaths.addAll(AAAConfigUtils.YANG_MODELS);
    }
}

