/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.applications.rnc.module;

import io.lighty.aaa.AAALighty;
import io.lighty.aaa.config.AAAConfiguration;
import io.lighty.aaa.config.CertificateManagerConfig;
import io.lighty.applications.rnc.module.config.RncLightyModuleConfiguration;
import io.lighty.applications.rnc.module.exception.RncLightyAppStartException;
import io.lighty.core.controller.api.LightyController;
import io.lighty.core.controller.api.LightyModule;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.core.controller.impl.LightyControllerBuilder;
import io.lighty.core.controller.impl.config.ConfigurationException;
import io.lighty.core.controller.impl.config.ControllerConfiguration;
import io.lighty.modules.northbound.restconf.community.impl.CommunityRestConf;
import io.lighty.modules.northbound.restconf.community.impl.CommunityRestConfBuilder;
import io.lighty.modules.northbound.restconf.community.impl.config.RestConfConfiguration;
import io.lighty.modules.northbound.restconf.community.impl.util.RestConfConfigUtils;
import io.lighty.modules.southbound.netconf.impl.NetconfSBPlugin;
import io.lighty.modules.southbound.netconf.impl.NetconfTopologyPluginBuilder;
import io.lighty.modules.southbound.netconf.impl.config.NetconfConfiguration;
import io.lighty.modules.southbound.netconf.impl.util.NetconfConfigUtils;
import io.lighty.openapi.OpenApiLighty;
import io.lighty.server.Http2LightyServerBuilder;
import io.lighty.server.HttpsLightyServerBuilder;
import io.lighty.server.LightyServerBuilder;
import io.lighty.server.config.LightyServerConfig;
import java.net.InetSocketAddress;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RncLightyModule {
    private static final Logger LOG = LoggerFactory.getLogger(RncLightyModule.class);
    private static final TimeUnit DEFAULT_LIGHTY_MODULE_TIME_UNIT = TimeUnit.SECONDS;
    private final RncLightyModuleConfiguration rncModuleConfig;
    private final long lightyModuleTimeout;
    private LightyController lightyController;
    private CommunityRestConf lightyRestconf;
    private NetconfSBPlugin lightyNetconf;
    private AAALighty aaaLighty;
    private LightyServerBuilder jettyServerBuilder;
    private OpenApiLighty openApi;

    public RncLightyModule(RncLightyModuleConfiguration rncModuleConfig) {
        LOG.info("Creating instance of RNC lighty.io module...");
        this.rncModuleConfig = rncModuleConfig;
        this.lightyModuleTimeout = rncModuleConfig.getModuleConfig().getModuleTimeoutSeconds();
        LOG.info("Instance of RNC lighty.io module created!");
    }

    public boolean initModules() {
        LOG.info("Initializing RNC lighty.io module...");
        try {
            this.lightyController = this.initController(this.rncModuleConfig.getControllerConfig());
            this.startAndWaitLightyModule((LightyModule)this.lightyController);
            this.lightyRestconf = this.initRestconf(this.rncModuleConfig.getRestconfConfig(), this.rncModuleConfig.getServerConfig(), this.lightyController.getServices());
            this.startAndWaitLightyModule((LightyModule)this.lightyRestconf);
            this.lightyNetconf = this.initNetconf(this.rncModuleConfig.getNetconfConfig(), this.lightyController.getServices());
            this.startAndWaitLightyModule((LightyModule)this.lightyNetconf);
            if (this.rncModuleConfig.getAaaConfig().isEnableAAA()) {
                this.aaaLighty = this.initAAA(this.rncModuleConfig.getAaaConfig(), this.lightyController.getServices());
                this.startAndWaitLightyModule((LightyModule)this.aaaLighty);
            }
            if (this.rncModuleConfig.getServerConfig().isEnableOpenApi()) {
                this.openApi = this.initOpenApiLighty(this.rncModuleConfig.getRestconfConfig(), this.jettyServerBuilder, this.lightyController.getServices());
                this.startAndWaitLightyModule((LightyModule)this.openApi);
            }
            this.lightyRestconf.startServer();
        }
        catch (RncLightyAppStartException e) {
            LOG.error("Unable to initialize and start RNC lighty.io module!", (Throwable)e);
            return false;
        }
        LOG.info("RNC lighty.io module initialized successfully!");
        return true;
    }

    private LightyController initController(ControllerConfiguration config) throws RncLightyAppStartException {
        try {
            return new LightyControllerBuilder().from(config).build();
        }
        catch (ConfigurationException e) {
            throw new RncLightyAppStartException("Unable to initialize lighty.io controller module!", e);
        }
    }

    private NetconfSBPlugin initNetconf(NetconfConfiguration config, LightyServices services) throws RncLightyAppStartException {
        try {
            NetconfConfiguration configWithServices = NetconfConfigUtils.injectServicesToTopologyConfig((NetconfConfiguration)config, (LightyServices)services);
            return NetconfTopologyPluginBuilder.from((NetconfConfiguration)configWithServices, (LightyServices)services).build();
        }
        catch (ConfigurationException e) {
            throw new RncLightyAppStartException("Unable to initialize lighty.io NETCONF module!", e);
        }
    }

    private CommunityRestConf initRestconf(RestConfConfiguration rcConfig, LightyServerConfig serverConfig, LightyServices services) {
        RestConfConfiguration restConfConfiguration = RestConfConfigUtils.getRestConfConfiguration((RestConfConfiguration)rcConfig, (LightyServices)services);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(rcConfig.getInetAddress(), rcConfig.getHttpPort());
        this.jettyServerBuilder = serverConfig.isUseHttp2() ? new Http2LightyServerBuilder(inetSocketAddress, serverConfig.getSecurityConfig()) : (serverConfig.isUseHttps() ? new HttpsLightyServerBuilder(inetSocketAddress, serverConfig.getSecurityConfig()) : new LightyServerBuilder(inetSocketAddress));
        return CommunityRestConfBuilder.from((RestConfConfiguration)restConfConfiguration).withLightyServer(this.jettyServerBuilder).withScheduledThreadPool(services.getScheduledThreadPool()).build();
    }

    private AAALighty initAAA(AAAConfiguration config, LightyServices services) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        config.setCertificateManager(CertificateManagerConfig.getDefault((DataBroker)services.getBindingDataBroker(), (RpcProviderService)services.getRpcProviderService()));
        return new AAALighty(services.getBindingDataBroker(), null, this.jettyServerBuilder, config);
    }

    private OpenApiLighty initOpenApiLighty(RestConfConfiguration config, LightyServerBuilder serverBuilder, LightyServices services) {
        return new OpenApiLighty(config, serverBuilder, services);
    }

    private void startAndWaitLightyModule(LightyModule lightyModule) throws RncLightyAppStartException {
        try {
            LOG.info("Initializing lighty.io module ({})...", lightyModule.getClass());
            boolean startSuccess = (Boolean)lightyModule.start().get(this.lightyModuleTimeout, DEFAULT_LIGHTY_MODULE_TIME_UNIT);
            if (!startSuccess) {
                throw new RncLightyAppStartException(String.format("Unable to initialize lighty.io module (%s)!", lightyModule.getClass()));
            }
            LOG.info("lighty.io module ({}) initialized successfully!", lightyModule.getClass());
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RncLightyAppStartException(String.format("Exception was thrown during initialization of lighty.io module (%s)!", lightyModule.getClass()), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RncLightyAppStartException(String.format("Exception was thrown during initialization of lighty.io module (%s)!", lightyModule.getClass()), e);
        }
    }

    public boolean close() {
        LOG.info("Stopping RNC lighty.io application...");
        boolean success = true;
        if (this.rncModuleConfig.getServerConfig().isEnableOpenApi() && this.openApi != null) {
            success &= this.openApi.shutdown(this.lightyModuleTimeout, DEFAULT_LIGHTY_MODULE_TIME_UNIT);
        }
        if (this.rncModuleConfig.getAaaConfig().isEnableAAA() && this.aaaLighty != null) {
            success &= this.aaaLighty.shutdown(this.lightyModuleTimeout, DEFAULT_LIGHTY_MODULE_TIME_UNIT);
        }
        if (this.lightyRestconf != null) {
            success &= this.lightyRestconf.shutdown(this.lightyModuleTimeout, DEFAULT_LIGHTY_MODULE_TIME_UNIT);
        }
        if (this.lightyNetconf != null) {
            success &= this.lightyNetconf.shutdown(this.lightyModuleTimeout, DEFAULT_LIGHTY_MODULE_TIME_UNIT);
        }
        if (this.lightyController != null) {
            success &= this.lightyController.shutdown(this.lightyModuleTimeout, DEFAULT_LIGHTY_MODULE_TIME_UNIT);
        }
        if (success) {
            LOG.info("RNC lighty.io module stopped successfully!");
            return true;
        }
        LOG.error("Some components of RNC lighty.io module were not stopped successfully!");
        return false;
    }
}

