/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.applications.rnc.module.config;

import java.security.KeyStore;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SecurityConfig {
    private final KeyStore keyStore;
    private final KeyStore trustKeyStore;
    private final String password;
    private final String trustPassword;
    private final SslContextFactory sslContextFactory;
    private final boolean isNeedClientAuth;

    public SecurityConfig(KeyStore keyStore, String password, KeyStore trustKeyStore, String trustPassword, boolean isNeedClientAuth) {
        this.keyStore = keyStore;
        this.password = password;
        this.trustKeyStore = trustKeyStore;
        this.trustPassword = trustPassword;
        this.isNeedClientAuth = isNeedClientAuth;
        this.sslContextFactory = new SslContextFactory.Server();
        this.initFactoryCtx();
    }

    private void initFactoryCtx() {
        this.sslContextFactory.setTrustStore(this.trustKeyStore);
        this.sslContextFactory.setTrustStorePassword(this.trustPassword);
        this.sslContextFactory.setKeyStore(this.keyStore);
        this.sslContextFactory.setKeyStorePassword(this.password);
        this.sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
        if (this.isNeedClientAuth) {
            this.sslContextFactory.setNeedClientAuth(true);
        }
    }

    public SslConnectionFactory getSslConnectionFactory(String protocol) {
        return new SslConnectionFactory(this.sslContextFactory, protocol);
    }
}

