/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.applications.rnc.module.config.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.lighty.applications.rnc.module.config.RncAAAConfiguration;
import io.lighty.core.controller.impl.config.ConfigurationException;
import io.lighty.modules.northbound.restconf.community.impl.config.RestConfConfiguration;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AAAConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AAAConfigUtils.class);
    public static final String AAA_ROOT_ELEMENT_NAME = "aaa";

    private AAAConfigUtils() {
        throw new UnsupportedOperationException();
    }

    public static RncAAAConfiguration getAAAConfiguration(InputStream jsonConfigInputStream) throws ConfigurationException {
        RncAAAConfiguration rncAaaConfiguration;
        JsonNode configNode;
        ObjectMapper mapper = new ObjectMapper();
        try {
            configNode = mapper.readTree(jsonConfigInputStream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot deserialize Json content to Json tree nodes", (Throwable)e);
        }
        if (!configNode.has(AAA_ROOT_ELEMENT_NAME)) {
            LOG.warn("Json config does not contain {} element. Using defaults.", (Object)AAA_ROOT_ELEMENT_NAME);
            return new RncAAAConfiguration();
        }
        JsonNode aaaNode = configNode.path(AAA_ROOT_ELEMENT_NAME);
        try {
            rncAaaConfiguration = (RncAAAConfiguration)mapper.treeToValue((TreeNode)aaaNode, RncAAAConfiguration.class);
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException(String.format("Cannot bind Json tree to type: %s", RestConfConfiguration.class), (Throwable)e);
        }
        return rncAaaConfiguration;
    }

    public static RncAAAConfiguration createDefaultAAAConfiguration() {
        return new RncAAAConfiguration();
    }
}

