/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.applications.rnc.module;

import io.lighty.aaa.AAALighty;
import io.lighty.aaa.config.CertificateManagerConfig;
import io.lighty.applications.rnc.module.HttpsLightyServerBuilder;
import io.lighty.applications.rnc.module.config.RncAAAConfiguration;
import io.lighty.applications.rnc.module.config.RncLightyModuleConfiguration;
import io.lighty.applications.rnc.module.config.RncRestConfConfiguration;
import io.lighty.applications.rnc.module.config.util.RncRestConfConfigUtils;
import io.lighty.applications.rnc.module.exception.RncLightyAppStartException;
import io.lighty.core.controller.api.AbstractLightyModule;
import io.lighty.core.controller.api.LightyController;
import io.lighty.core.controller.api.LightyModule;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.core.controller.impl.LightyControllerBuilder;
import io.lighty.core.controller.impl.config.ConfigurationException;
import io.lighty.core.controller.impl.config.ControllerConfiguration;
import io.lighty.modules.northbound.restconf.community.impl.CommunityRestConf;
import io.lighty.modules.northbound.restconf.community.impl.CommunityRestConfBuilder;
import io.lighty.modules.northbound.restconf.community.impl.config.RestConfConfiguration;
import io.lighty.modules.southbound.netconf.impl.NetconfSBPlugin;
import io.lighty.modules.southbound.netconf.impl.NetconfTopologyPluginBuilder;
import io.lighty.modules.southbound.netconf.impl.config.NetconfConfiguration;
import io.lighty.modules.southbound.netconf.impl.util.NetconfConfigUtils;
import io.lighty.server.LightyServerBuilder;
import java.net.InetSocketAddress;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RncLightyModule
extends AbstractLightyModule {
    private static final Logger LOG = LoggerFactory.getLogger(RncLightyModule.class);
    private static final long DEFAULT_LIGHTY_MODULE_TIMEOUT = 60L;
    private static final TimeUnit DEFAULT_LIGHTY_MODULE_TIME_UNIT = TimeUnit.SECONDS;
    private final RncLightyModuleConfiguration rncModuleConfig;
    private LightyController lightyController;
    private CommunityRestConf lightyRestconf;
    private NetconfSBPlugin lightyNetconf;
    private AAALighty aaaLighty;
    private LightyServerBuilder jettyServerBuilder;

    public RncLightyModule(RncLightyModuleConfiguration rncModuleConfig) {
        LOG.info("Creating instance of RNC lighty.io module...");
        this.rncModuleConfig = rncModuleConfig;
        LOG.info("Instance of RNC lighty.io module created!");
    }

    protected boolean initProcedure() {
        LOG.info("Initializing RNC lighty.io module...");
        try {
            this.lightyController = this.initController(this.rncModuleConfig.getControllerConfig());
            this.startAndWaitLightyModule((LightyModule)this.lightyController);
            this.lightyRestconf = this.initRestconf(this.rncModuleConfig.getRestconfConfig(), this.lightyController.getServices());
            this.startAndWaitLightyModule((LightyModule)this.lightyRestconf);
            this.lightyNetconf = this.initNetconf(this.rncModuleConfig.getNetconfConfig(), this.lightyController.getServices());
            this.startAndWaitLightyModule((LightyModule)this.lightyNetconf);
            if (this.rncModuleConfig.getAaaConfig().isEnableAAA()) {
                this.aaaLighty = this.initAAA(this.rncModuleConfig.getAaaConfig(), this.lightyController.getServices());
                this.startAndWaitLightyModule((LightyModule)this.aaaLighty);
            }
            this.lightyRestconf.startServer();
        }
        catch (RncLightyAppStartException e) {
            LOG.error("Unable to initialize and start RNC lighty.io module!", (Throwable)e);
            return false;
        }
        LOG.info("RNC lighty.io module initialized successfully!");
        return true;
    }

    private LightyController initController(ControllerConfiguration config) throws RncLightyAppStartException {
        LightyControllerBuilder lightyControllerBuilder = new LightyControllerBuilder();
        try {
            return lightyControllerBuilder.from(config).build();
        }
        catch (ConfigurationException e) {
            throw new RncLightyAppStartException("Unable to initialize lighty.io controller module!", e);
        }
    }

    private NetconfSBPlugin initNetconf(NetconfConfiguration config, LightyServices services) throws RncLightyAppStartException {
        try {
            NetconfConfiguration configWithServices = NetconfConfigUtils.injectServicesToTopologyConfig((NetconfConfiguration)config, (LightyServices)services);
            return NetconfTopologyPluginBuilder.from((NetconfConfiguration)configWithServices, (LightyServices)services).build();
        }
        catch (ConfigurationException e) {
            throw new RncLightyAppStartException("Unable to initialize lighty.io NETCONF module!", e);
        }
    }

    private CommunityRestConf initRestconf(RncRestConfConfiguration config, LightyServices services) {
        RncRestConfConfiguration confConf = RncRestConfConfigUtils.getRestConfConfiguration(config, services);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(confConf.getInetAddress(), confConf.getHttpPort());
        this.jettyServerBuilder = confConf.isUseHttps() ? new HttpsLightyServerBuilder(inetSocketAddress, config.getSecurityConfig()) : new LightyServerBuilder(inetSocketAddress);
        return CommunityRestConfBuilder.from((RestConfConfiguration)confConf).withLightyServer(this.jettyServerBuilder).build();
    }

    private AAALighty initAAA(RncAAAConfiguration config, LightyServices services) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        DataBroker dataBroker = services.getBindingDataBroker();
        config.setCertificateManager(CertificateManagerConfig.getDefault((DataBroker)services.getBindingDataBroker()));
        return new AAALighty(dataBroker, config.getCertificateManager(), null, config.getShiroConf(), config.getMoonEndpointPath(), config.getDatastoreConf(), config.getDbUsername(), config.getDbPassword(), this.jettyServerBuilder);
    }

    private void startAndWaitLightyModule(LightyModule lightyModule) throws RncLightyAppStartException {
        try {
            LOG.info("Initializing lighty.io module ({})...", lightyModule.getClass());
            boolean startSuccess = (Boolean)lightyModule.start().get(60L, DEFAULT_LIGHTY_MODULE_TIME_UNIT);
            if (!startSuccess) {
                throw new RncLightyAppStartException(String.format("Unable to initialize lighty.io module (%s)!", lightyModule.getClass()));
            }
            LOG.info("lighty.io module ({}) initialized successfully!", lightyModule.getClass());
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RncLightyAppStartException(String.format("Exception was thrown during initialization of lighty.io module (%s)!", lightyModule.getClass()), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RncLightyAppStartException(String.format("Exception was thrown during initialization of lighty.io module (%s)!", lightyModule.getClass()), e);
        }
    }

    protected boolean stopProcedure() {
        LOG.info("Stopping RNC lighty.io application...");
        boolean success = true;
        if (this.rncModuleConfig.getAaaConfig().isEnableAAA() && this.aaaLighty != null && !this.stopAndWaitLightyModule((LightyModule)this.aaaLighty)) {
            success = false;
        }
        if (this.lightyRestconf != null && !this.stopAndWaitLightyModule((LightyModule)this.lightyRestconf)) {
            success = false;
        }
        if (this.lightyNetconf != null && !this.stopAndWaitLightyModule((LightyModule)this.lightyNetconf)) {
            success = false;
        }
        if (this.lightyController != null && !this.stopAndWaitLightyModule((LightyModule)this.lightyController)) {
            success = false;
        }
        if (success) {
            LOG.info("RNC lighty.io module stopped successfully!");
            return true;
        }
        LOG.error("Some components of RNC lighty.io module were not stopped successfully!");
        return false;
    }

    private boolean stopAndWaitLightyModule(LightyModule lightyModule) {
        try {
            LOG.info("Stopping lighty.io module ({})...", lightyModule.getClass());
            boolean stopSuccess = (Boolean)lightyModule.shutdown().get(60L, DEFAULT_LIGHTY_MODULE_TIME_UNIT);
            if (stopSuccess) {
                LOG.info("lighty.io module ({}) stopped successfully!", lightyModule.getClass());
                return true;
            }
            LOG.error("Unable to stop lighty.io module ({})!", lightyModule.getClass());
            return false;
        }
        catch (Exception e) {
            LOG.error("Exception was thrown while stopping the lighty.io module ({})!", lightyModule.getClass(), (Object)e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return false;
        }
    }
}

