/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.applications.rnc.module.config.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.lighty.applications.rnc.module.config.RncLightyModuleConfigUtils;
import io.lighty.applications.rnc.module.config.RncRestConfConfiguration;
import io.lighty.applications.rnc.module.config.SecurityConfig;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.core.controller.impl.config.ConfigurationException;
import io.lighty.modules.northbound.restconf.community.impl.config.RestConfConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RncRestConfConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RncRestConfConfigUtils.class);

    private RncRestConfConfigUtils() {
        throw new UnsupportedOperationException();
    }

    public static RncRestConfConfiguration getRestConfConfiguration(InputStream jsonConfigInputStream) throws ConfigurationException {
        RncRestConfConfiguration restconfConfigurationrnc;
        JsonNode configNode;
        ObjectMapper mapper = new ObjectMapper();
        try {
            configNode = mapper.readTree(jsonConfigInputStream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot deserialize Json content to Json tree nodes", (Throwable)e);
        }
        if (!configNode.has("restconf")) {
            LOG.warn("Json config does not contain {} element. Using defaults.", (Object)"restconf");
            return new RncRestConfConfiguration();
        }
        JsonNode restconfNode = configNode.path("restconf");
        try {
            restconfConfigurationrnc = (RncRestConfConfiguration)((Object)mapper.treeToValue((TreeNode)restconfNode, RncRestConfConfiguration.class));
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException(String.format("Cannot bind Json tree to type: %s", RestConfConfiguration.class), (Throwable)e);
        }
        return restconfConfigurationrnc;
    }

    public static RncRestConfConfiguration getRestConfConfiguration(RncRestConfConfiguration rncRestConfConfiguration, LightyServices lightyServices) {
        RncRestConfConfiguration config = new RncRestConfConfiguration(rncRestConfConfiguration);
        config.setDomDataBroker(lightyServices.getClusteredDOMDataBroker());
        config.setSchemaService(lightyServices.getDOMSchemaService());
        config.setDomRpcService(lightyServices.getDOMRpcService());
        config.setDomActionService(lightyServices.getDOMActionService());
        config.setDomNotificationService(lightyServices.getDOMNotificationService());
        config.setDomMountPointService(lightyServices.getDOMMountPointService());
        config.setDomSchemaService(lightyServices.getDOMSchemaService());
        return config;
    }

    public static RncRestConfConfiguration getDefaultRestConfConfiguration() {
        return new RncRestConfConfiguration();
    }

    public static SecurityConfig createSecurityConfig(RncRestConfConfiguration config) throws ConfigurationException {
        try {
            KeyStore.PasswordProtection passProtection = new KeyStore.PasswordProtection(config.getKeyStorePassword().toCharArray());
            KeyStore keyStore = KeyStore.Builder.newInstance(config.getKeyStoreType(), null, passProtection).getKeyStore();
            Optional<InputStream> ksFile = RncRestConfConfigUtils.readKeyStoreFile(config.getKeyStoreFilePath());
            if (ksFile.isEmpty()) {
                throw new ConfigurationException("Unable to create KeyStore configuration: KeyStore file was not found on path: " + config.getKeyStoreFilePath());
            }
            keyStore.load(ksFile.get(), config.getKeyStorePassword().toCharArray());
            return new SecurityConfig(keyStore, config.getKeyStorePassword());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new ConfigurationException("Unable to create KeyStore configuration", (Throwable)e);
        }
    }

    private static Optional<InputStream> readKeyStoreFile(String keyStoreFilePath) throws IOException {
        InputStream ksFile;
        try {
            LOG.info("Trying to load KeyStore from filesystem from path {}", (Object)keyStoreFilePath);
            ksFile = Files.newInputStream(Paths.get(keyStoreFilePath, new String[0]), new OpenOption[0]);
            LOG.info("KeyStore found on filesystem on path {}", (Object)keyStoreFilePath);
        }
        catch (NoSuchFileException e) {
            LOG.info("KeyStore not found on filesystem, looking in resources on path {}", (Object)keyStoreFilePath);
            ksFile = RncLightyModuleConfigUtils.class.getClassLoader().getResourceAsStream(keyStoreFilePath);
            LOG.info("KeyStore found on classpath on path {}", (Object)keyStoreFilePath);
        }
        if (ksFile == null) {
            LOG.error("KeyStore was not found on path {} in filesystem or resources", (Object)keyStoreFilePath);
        }
        return Optional.ofNullable(ksFile);
    }
}

