/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.applications.rnc.module.config;

import java.security.KeyStore;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SecurityConfig {
    private final KeyStore keyStore;
    private final String password;
    private final SslContextFactory sslContextFactory;

    public SecurityConfig(KeyStore keyStore, String password) {
        this.keyStore = keyStore;
        this.password = password;
        this.sslContextFactory = new SslContextFactory.Server();
        this.initFactoryCtx();
    }

    private void initFactoryCtx() {
        this.sslContextFactory.setTrustStore(this.keyStore);
        this.sslContextFactory.setTrustStorePassword(this.password);
        this.sslContextFactory.setKeyStore(this.keyStore);
        this.sslContextFactory.setKeyStorePassword(this.password);
        this.sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
    }

    public SslConnectionFactory getSslConnectionFactory(String protocol) {
        return new SslConnectionFactory(this.sslContextFactory, protocol);
    }
}

