/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.applications.rnc.module;

import io.lighty.applications.rnc.module.config.SecurityConfig;
import io.lighty.server.LightyServerBuilder;
import java.net.InetSocketAddress;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;

public class HttpsLightyServerBuilder
extends LightyServerBuilder {
    private final SecurityConfig securityConfig;

    public HttpsLightyServerBuilder(InetSocketAddress inetSocketAddress, SecurityConfig securityConfig) {
        super(inetSocketAddress);
        this.server = new Server();
        this.securityConfig = securityConfig;
    }

    public Server build() {
        Server server = super.build();
        SslConnectionFactory ssl = this.securityConfig.getSslConnectionFactory(HttpVersion.HTTP_1_1.asString());
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{ssl, this.httpConfiguration(this.inetSocketAddress)});
        sslConnector.setPort(this.inetSocketAddress.getPort());
        server.addConnector((Connector)sslConnector);
        return server;
    }

    private HttpConnectionFactory httpConfiguration(InetSocketAddress inetSocketAddress) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecurePort(inetSocketAddress.getPort());
        httpConfig.setSendXPoweredBy(true);
        HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        return new HttpConnectionFactory(httpsConfig);
    }
}

