/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.applications.rcgnmi.module;

import com.typesafe.config.Config;
import io.lighty.applications.rcgnmi.module.RcGnmiAppConfiguration;
import io.lighty.applications.util.ModulesConfig;
import io.lighty.core.controller.impl.config.ConfigurationException;
import io.lighty.core.controller.impl.config.ControllerConfiguration;
import io.lighty.core.controller.impl.util.ControllerConfigUtils;
import io.lighty.gnmi.southbound.lightymodule.config.GnmiConfiguration;
import io.lighty.gnmi.southbound.lightymodule.util.GnmiConfigUtils;
import io.lighty.modules.northbound.restconf.community.impl.config.RestConfConfiguration;
import io.lighty.modules.northbound.restconf.community.impl.util.RestConfConfigUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RcGnmiAppModuleConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RcGnmiAppModuleConfigUtils.class);

    private RcGnmiAppModuleConfigUtils() {
        throw new UnsupportedOperationException();
    }

    public static RcGnmiAppConfiguration loadDefaultConfig() throws ConfigurationException {
        LOG.debug("Loading default lighty.io controller module configuration...");
        HashSet<YangModuleInfo> modelPaths = new HashSet<YangModuleInfo>();
        RcGnmiAppModuleConfigUtils.defaultModels(modelPaths);
        ControllerConfiguration controllerConfig = ControllerConfigUtils.getDefaultSingleNodeConfiguration(modelPaths);
        LOG.debug("Loading default lighty.io RESTCONF module configuration...");
        RestConfConfiguration restconfConfig = RestConfConfigUtils.getDefaultRestConfConfiguration();
        restconfConfig.setInetAddress(new InetSocketAddress(restconfConfig.getHttpPort()).getAddress());
        LOG.debug("Loading default lighty.io gNMI module configuration...");
        GnmiConfiguration gnmiConfiguration = GnmiConfigUtils.getDefaultGnmiConfiguration();
        LOG.debug("Loading default lighty.io app modules configuration...");
        ModulesConfig modulesConfig = ModulesConfig.getDefaultModulesConfig();
        return new RcGnmiAppConfiguration(controllerConfig, restconfConfig, gnmiConfiguration, modulesConfig);
    }

    public static RcGnmiAppConfiguration loadConfiguration(Path path) throws ConfigurationException, IOException {
        LOG.debug("Loading lighty.io controller module configuration...");
        ControllerConfiguration controllerConfig = ControllerConfigUtils.getConfiguration((InputStream)Files.newInputStream(path, new OpenOption[0]));
        Config akkaConfig = controllerConfig.getActorSystemConfig().getConfig().resolve();
        controllerConfig.getActorSystemConfig().setConfig(akkaConfig);
        LOG.debug("Loading lighty.io RESTCONF module configuration...");
        RestConfConfiguration restconfConfig = RestConfConfigUtils.getRestConfConfiguration((InputStream)Files.newInputStream(path, new OpenOption[0]));
        RestConfConfiguration defaultRestconfConfig = RestConfConfigUtils.getDefaultRestConfConfiguration();
        if (restconfConfig.getInetAddress().equals(defaultRestconfConfig.getInetAddress())) {
            restconfConfig.setInetAddress(new InetSocketAddress(restconfConfig.getHttpPort()).getAddress());
        }
        LOG.debug("Loading lighty.io gNMI module configuration...");
        GnmiConfiguration gnmiConfiguration = GnmiConfigUtils.getGnmiConfiguration((InputStream)Files.newInputStream(path, new OpenOption[0]));
        LOG.debug("Loading lighty.io app modules configuration...");
        ModulesConfig modulesConfig = ModulesConfig.getModulesConfig((InputStream)Files.newInputStream(path, new OpenOption[0]));
        return new RcGnmiAppConfiguration(controllerConfig, restconfConfig, gnmiConfiguration, modulesConfig);
    }

    private static void defaultModels(Set<YangModuleInfo> modelPaths) {
        modelPaths.addAll(RestConfConfigUtils.YANG_MODELS);
        modelPaths.addAll(GnmiConfigUtils.YANG_MODELS);
    }
}

