/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.applications.rcgnmi.module;

import io.lighty.aaa.encrypt.service.impl.AAAEncryptionServiceImpl;
import io.lighty.applications.rcgnmi.module.RcGnmiAppConfiguration;
import io.lighty.applications.rcgnmi.module.RcGnmiAppException;
import io.lighty.core.controller.api.LightyController;
import io.lighty.core.controller.api.LightyModule;
import io.lighty.core.controller.api.LightyServices;
import io.lighty.core.controller.impl.LightyControllerBuilder;
import io.lighty.core.controller.impl.config.ConfigurationException;
import io.lighty.core.controller.impl.config.ControllerConfiguration;
import io.lighty.gnmi.southbound.lightymodule.GnmiSouthboundModule;
import io.lighty.gnmi.southbound.lightymodule.GnmiSouthboundModuleBuilder;
import io.lighty.gnmi.southbound.lightymodule.config.GnmiConfiguration;
import io.lighty.modules.northbound.restconf.community.impl.CommunityRestConf;
import io.lighty.modules.northbound.restconf.community.impl.CommunityRestConfBuilder;
import io.lighty.modules.northbound.restconf.community.impl.config.RestConfConfiguration;
import io.lighty.modules.northbound.restconf.community.impl.util.RestConfConfigUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.yang.gen.v1.config.aaa.authn.encrypt.service.config.rev160915.AaaEncryptServiceConfig;
import org.opendaylight.yang.gen.v1.config.aaa.authn.encrypt.service.config.rev160915.AaaEncryptServiceConfigBuilder;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.CrossSourceStatementReactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RcGnmiAppModule {
    private static final Logger LOG = LoggerFactory.getLogger(RcGnmiAppModule.class);
    private static final TimeUnit DEFAULT_LIGHTY_MODULE_TIME_UNIT = TimeUnit.SECONDS;
    private static final SecureRandom RANDOM = new SecureRandom();
    private final long lightyModuleTimeout;
    private final RcGnmiAppConfiguration appModuleConfig;
    private final ExecutorService gnmiExecutorService;
    private final CrossSourceStatementReactor customReactor;
    private LightyController lightyController;
    private CommunityRestConf lightyRestconf;
    private GnmiSouthboundModule gnmiSouthboundModule;

    public RcGnmiAppModule(RcGnmiAppConfiguration appModuleConfig, ExecutorService gnmiExecutorService, @Nullable CrossSourceStatementReactor customReactor) {
        LOG.info("Creating instance of RgNMI lighty.io module...");
        this.appModuleConfig = Objects.requireNonNull(appModuleConfig);
        this.gnmiExecutorService = Objects.requireNonNull(gnmiExecutorService);
        this.lightyModuleTimeout = appModuleConfig.getModulesConfig().getModuleTimeoutSeconds();
        this.customReactor = customReactor;
        LOG.info("Instance of RCgNMI lighty.io module created!");
    }

    public boolean initModules() {
        LOG.info("Initializing RCgNMI lighty.io module...");
        try {
            this.lightyController = this.initController(this.appModuleConfig.getControllerConfig());
            this.startAndWaitLightyModule((LightyModule)this.lightyController);
            this.lightyRestconf = this.initRestconf(this.appModuleConfig.getRestconfConfig(), this.lightyController.getServices());
            this.startAndWaitLightyModule((LightyModule)this.lightyRestconf);
            AAAEncryptionService encryptionService = this.createEncryptionServiceWithErrorHandling();
            this.gnmiSouthboundModule = this.initGnmiModule(this.lightyController.getServices(), this.gnmiExecutorService, this.appModuleConfig.getGnmiConfiguration(), encryptionService, this.customReactor);
            this.startAndWaitLightyModule((LightyModule)this.gnmiSouthboundModule);
        }
        catch (RcGnmiAppException e) {
            LOG.error("Unable to initialize and start RCgNMI lighty.io module!", (Throwable)e);
            return false;
        }
        LOG.info("RCgNMI lighty.io module initialized successfully!");
        return true;
    }

    private LightyController initController(ControllerConfiguration config) throws RcGnmiAppException {
        LightyControllerBuilder lightyControllerBuilder = new LightyControllerBuilder();
        try {
            return lightyControllerBuilder.from(config).build();
        }
        catch (ConfigurationException e) {
            throw new RcGnmiAppException("Unable to initialize lighty.io controller module!", e);
        }
    }

    private CommunityRestConf initRestconf(RestConfConfiguration config, LightyServices services) {
        RestConfConfiguration conf = RestConfConfigUtils.getRestConfConfiguration((RestConfConfiguration)config, (LightyServices)services);
        return CommunityRestConfBuilder.from((RestConfConfiguration)conf).build();
    }

    private GnmiSouthboundModule initGnmiModule(LightyServices services, ExecutorService gnmiExecService, GnmiConfiguration gnmiConfiguration, AAAEncryptionService encryptionService, CrossSourceStatementReactor reactor) {
        return new GnmiSouthboundModuleBuilder().withConfig(gnmiConfiguration).withLightyServices(services).withExecutorService(gnmiExecService).withEncryptionService(encryptionService).withReactor(reactor).build();
    }

    private void startAndWaitLightyModule(LightyModule lightyModule) throws RcGnmiAppException {
        try {
            LOG.info("Initializing lighty.io module ({})...", lightyModule.getClass());
            boolean startSuccess = (Boolean)lightyModule.start().get(this.lightyModuleTimeout, DEFAULT_LIGHTY_MODULE_TIME_UNIT);
            if (!startSuccess) {
                throw new RcGnmiAppException(String.format("Unable to initialize lighty.io module (%s)!", lightyModule.getClass()));
            }
            LOG.info("lighty.io module ({}) initialized successfully!", lightyModule.getClass());
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RcGnmiAppException(String.format("Exception was thrown during initialization of lighty.io module (%s)!", lightyModule.getClass()), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RcGnmiAppException(String.format("Exception was thrown during initialization of lighty.io module (%s)!", lightyModule.getClass()), e);
        }
    }

    public boolean close() {
        LOG.info("Stopping RCgNMI lighty.io application...");
        boolean success = true;
        if (this.lightyRestconf != null) {
            success &= this.lightyRestconf.shutdown(this.lightyModuleTimeout, DEFAULT_LIGHTY_MODULE_TIME_UNIT);
        }
        if (this.lightyController != null) {
            success &= this.lightyController.shutdown(this.lightyModuleTimeout, DEFAULT_LIGHTY_MODULE_TIME_UNIT);
        }
        if (this.gnmiSouthboundModule != null) {
            success &= this.gnmiSouthboundModule.shutdown(this.lightyModuleTimeout, DEFAULT_LIGHTY_MODULE_TIME_UNIT);
        }
        if (success) {
            LOG.info("RCgNMI lighty.io module stopped successfully!");
            return true;
        }
        LOG.error("Some components of RCgNMI lighty.io module were not stopped successfully!");
        return false;
    }

    private AAAEncryptionService createEncryptionServiceWithErrorHandling() throws RcGnmiAppException {
        try {
            return this.createEncryptionService();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            throw new RcGnmiAppException("Failed to create Encryption Service", e);
        }
    }

    private AAAEncryptionServiceImpl createEncryptionService() throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidAlgorithmParameterException, InvalidKeyException {
        AaaEncryptServiceConfig encrySrvConfig = this.getDefaultAaaEncryptServiceConfig();
        byte[] encryptionKeySalt = Base64.getDecoder().decode(encrySrvConfig.getEncryptSalt());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(encrySrvConfig.getEncryptMethod());
        PBEKeySpec keySpec = new PBEKeySpec(encrySrvConfig.getEncryptKey().toCharArray(), encryptionKeySalt, encrySrvConfig.getEncryptIterationCount(), encrySrvConfig.getEncryptKeyLength());
        SecretKeySpec key = new SecretKeySpec(keyFactory.generateSecret(keySpec).getEncoded(), encrySrvConfig.getEncryptType());
        IvParameterSpec ivParameterSpec = new IvParameterSpec(encryptionKeySalt);
        Cipher encryptCipher = Cipher.getInstance(encrySrvConfig.getCipherTransforms());
        encryptCipher.init(1, (Key)key, ivParameterSpec);
        Cipher decryptCipher = Cipher.getInstance(encrySrvConfig.getCipherTransforms());
        decryptCipher.init(2, (Key)key, ivParameterSpec);
        return new AAAEncryptionServiceImpl(encryptCipher, decryptCipher);
    }

    private AaaEncryptServiceConfig getDefaultAaaEncryptServiceConfig() {
        byte[] bytes = new byte[16];
        RANDOM.nextBytes(bytes);
        String salt = new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8);
        return new AaaEncryptServiceConfigBuilder().setEncryptKey("V1S1ED4OMeEh").setPasswordLength(Integer.valueOf(12)).setEncryptSalt(salt).setEncryptMethod("PBKDF2WithHmacSHA1").setEncryptType("AES").setEncryptIterationCount(Integer.valueOf(32768)).setEncryptKeyLength(Integer.valueOf(128)).setCipherTransforms("AES/CBC/PKCS5Padding").build();
    }
}

