/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.applications.util;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.lighty.core.controller.impl.config.ConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ModulesConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ModulesConfig.class);
    private static final String MODULES_ELEMENT_NAME = "modules";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private long moduleTimeoutSeconds = 60L;

    public static ModulesConfig getModulesConfig(InputStream jsonConfigInputStream) throws ConfigurationException {
        JsonNode configNode;
        try {
            configNode = MAPPER.readTree(jsonConfigInputStream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot deserialize Json content to Json tree nodes", (Throwable)e);
        }
        if (!configNode.has(MODULES_ELEMENT_NAME)) {
            LOG.warn("Json config does not contain {} element. Using defaults.", (Object)MODULES_ELEMENT_NAME);
            return ModulesConfig.getDefaultModulesConfig();
        }
        JsonNode modulesNode = configNode.path(MODULES_ELEMENT_NAME);
        try {
            return (ModulesConfig)MAPPER.treeToValue((TreeNode)modulesNode, ModulesConfig.class);
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException(String.format("Cannot bind Json tree to type: %s", ModulesConfig.class), (Throwable)e);
        }
    }

    public static ModulesConfig getDefaultModulesConfig() {
        return new ModulesConfig();
    }

    public long getModuleTimeoutSeconds() {
        return this.moduleTimeoutSeconds;
    }

    public void setModuleTimeoutSeconds(long moduleTimeoutSeconds) {
        this.moduleTimeoutSeconds = moduleTimeoutSeconds;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModulesConfig)) {
            return false;
        }
        ModulesConfig that = (ModulesConfig)obj;
        return this.moduleTimeoutSeconds == that.moduleTimeoutSeconds;
    }

    public int hashCode() {
        return Objects.hash(this.moduleTimeoutSeconds);
    }
}

