/*
 * Decompiled with CFR 0.152.
 */
package liberalize.java.backend.sdk.data.network;

import com.google.gson.Gson;
import javax.annotation.Nullable;
import liberalize.java.backend.sdk.data.model.AuthorizePaymentRequest;
import liberalize.java.backend.sdk.data.model.CapturePaymentRequest;
import liberalize.java.backend.sdk.data.model.CreatePaymentRequest;
import liberalize.java.backend.sdk.data.model.PaymentDetailsResponse;
import liberalize.java.backend.sdk.data.model.PaymentFlowResponse;
import liberalize.java.backend.sdk.data.model.RefundPaymentRequest;
import liberalize.java.backend.sdk.data.network.ApiClient;
import liberalize.java.backend.sdk.data.network.ApiResponse;
import liberalize.java.backend.sdk.data.network.ApiResult;
import liberalize.java.backend.sdk.data.network.HttpClient;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class ApiClientImpl
implements ApiClient {
    private final HttpClient httpClient;
    private final Gson gson = new Gson();

    public ApiClientImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public void createPayment(CreatePaymentRequest createPaymentRequest, String libService, ApiResult<PaymentFlowResponse> apiResult) {
        String body = this.gson.toJson((Object)createPaymentRequest);
        this.postData("/payments", body, libService, apiResult);
    }

    @Override
    public void authorizePayment(AuthorizePaymentRequest request, String libService, String paymentId, ApiResult<PaymentFlowResponse> apiResult) {
        String body = this.gson.toJson((Object)request);
        String path = "/payments/" + paymentId + "/authorizations";
        this.postData(path, body, libService, apiResult);
    }

    @Override
    public void capturePayment(CapturePaymentRequest request, String libService, String paymentId, ApiResult<PaymentFlowResponse> apiResult) {
        String body = this.gson.toJson((Object)request);
        String path = "/payments/" + paymentId + "/captures";
        this.postData(path, body, libService, apiResult);
    }

    @Override
    public void voidPayment(String libService, String paymentId, ApiResult<PaymentFlowResponse> apiResult) {
        String path = "/payments/" + paymentId + "/voids";
        this.postData(path, "{}", libService, apiResult);
    }

    @Override
    public void refundPayment(RefundPaymentRequest request, String libService, String paymentId, ApiResult<PaymentFlowResponse> apiResult) {
        String body = this.gson.toJson((Object)request);
        String path = "/payments/" + paymentId + "/refunds";
        this.postData(path, body, libService, apiResult);
    }

    @Override
    public void getPayment(String libService, String paymentId, final ApiResult<PaymentDetailsResponse> apiResult) {
        String path = "/payments/" + paymentId;
        this.httpClient.get(path, this.createHeaders(libService), new ApiResponse(){

            @Override
            public void onSuccess(String body) {
                try {
                    PaymentDetailsResponse paymentResponse = (PaymentDetailsResponse)ApiClientImpl.this.gson.fromJson(body, PaymentDetailsResponse.class);
                    apiResult.onSuccess(paymentResponse);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    apiResult.onError("Oops! Technical issue");
                }
            }

            @Override
            public void onError(String errorMessage) {
                apiResult.onError(errorMessage);
            }
        });
    }

    private Headers createHeaders(String libService) {
        return Headers.of((String[])new String[]{"x-lib-pos-type", libService});
    }

    private void postData(String path, @Nullable String body, String libService, final ApiResult<PaymentFlowResponse> apiResult) {
        RequestBody requestBody = null;
        MediaType json = MediaType.parse((String)"application/json; charset=utf-8");
        if (body != null) {
            requestBody = RequestBody.create((MediaType)json, (String)body);
        }
        this.httpClient.post(path, this.createHeaders(libService), requestBody, new ApiResponse(){

            @Override
            public void onSuccess(String body) {
                try {
                    PaymentFlowResponse paymentResponse = (PaymentFlowResponse)ApiClientImpl.this.gson.fromJson(body, PaymentFlowResponse.class);
                    apiResult.onSuccess(paymentResponse);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    apiResult.onError("Oops! Technical issue");
                }
            }

            @Override
            public void onError(String errorMessage) {
                apiResult.onError(errorMessage);
            }
        });
    }
}

