/*
 * Decompiled with CFR 0.152.
 */
package liberalize.java.backend.sdk;

import liberalize.java.backend.sdk.data.model.AuthorizePaymentRequest;
import liberalize.java.backend.sdk.data.model.CapturePaymentRequest;
import liberalize.java.backend.sdk.data.model.CreatePaymentRequest;
import liberalize.java.backend.sdk.data.model.PaymentDetailsResponse;
import liberalize.java.backend.sdk.data.model.PaymentFlowResponse;
import liberalize.java.backend.sdk.data.model.RefundPaymentRequest;
import liberalize.java.backend.sdk.data.network.ApiClient;
import liberalize.java.backend.sdk.data.network.ApiClientImpl;
import liberalize.java.backend.sdk.data.network.ApiResult;
import liberalize.java.backend.sdk.data.network.Authorization;
import liberalize.java.backend.sdk.data.network.Environment;
import liberalize.java.backend.sdk.data.network.HttpClientImpl;

public class LiberalizeBE {
    private static LiberalizeBE instance = null;
    private Environment environment;
    protected ApiClient apiClient;

    protected LiberalizeBE() {
    }

    public void setPrivateKey(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.apiClient = new ApiClientImpl(new HttpClientImpl(new Authorization(key)));
    }

    public void setEnvironment(Environment env) {
        this.environment = env;
    }

    public static synchronized LiberalizeBE getInstance() {
        if (instance == null) {
            instance = new LiberalizeBE();
        }
        return instance;
    }

    public Environment getEnv() {
        return this.environment;
    }

    public void createPayment(CreatePaymentRequest createPaymentRequest, String libService, ApiResult<PaymentFlowResponse> result) {
        this.apiClient.createPayment(createPaymentRequest, libService, result);
    }

    public void authorizePayment(AuthorizePaymentRequest request, String libService, String paymentId, ApiResult<PaymentFlowResponse> result) {
        this.apiClient.authorizePayment(request, libService, paymentId, result);
    }

    public void capturePayment(CapturePaymentRequest request, String libService, String paymentId, ApiResult<PaymentFlowResponse> result) {
        this.apiClient.capturePayment(request, libService, paymentId, result);
    }

    public void voidPayment(String libService, String paymentId, ApiResult<PaymentFlowResponse> result) {
        this.apiClient.voidPayment(libService, paymentId, result);
    }

    public void refundPayment(RefundPaymentRequest request, String libService, String paymentId, ApiResult<PaymentFlowResponse> result) {
        this.apiClient.refundPayment(request, libService, paymentId, result);
    }

    public void getPayment(String libService, String paymentId, ApiResult<PaymentDetailsResponse> result) {
        this.apiClient.getPayment(libService, paymentId, result);
    }
}

