/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.oracle;

import io.leoplatform.sdk.oracle.OracleChangeSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import oracle.jdbc.OracleConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleOracleChangeSource
implements OracleChangeSource {
    private static final Logger log = LoggerFactory.getLogger(SimpleOracleChangeSource.class);
    private final OracleConnection conn;
    private final List<String> tables;

    public SimpleOracleChangeSource(OracleConnection conn, Collection<String> tables) {
        this.conn = Optional.ofNullable(conn).filter(this::pingable).orElseThrow(() -> new IllegalStateException("Missing or invalid connection"));
        this.tables = this.validate(tables);
    }

    private List<String> validate(Collection<String> tables) {
        List tbls = ((Collection)Optional.ofNullable(tables).orElse(Collections.emptyList())).stream().filter(Objects::nonNull).map(String::trim).filter(t -> !t.isEmpty()).collect(Collectors.toList());
        return Optional.of(tbls).filter(t -> !t.isEmpty()).orElseThrow(() -> new IllegalArgumentException("Must watch one or more tables"));
    }

    private boolean pingable(OracleConnection c) {
        try {
            return c.pingDatabase() == 0;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cannot ping database", e);
        }
    }

    @Override
    public OracleConnection connection() {
        return this.conn;
    }

    public List<String> tables() {
        return this.tables;
    }

    public void end() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            log.warn("Could not close connection", (Throwable)e);
        }
    }
}

