/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.oracle;

import com.typesafe.config.Config;
import io.leoplatform.schema.Field;
import io.leoplatform.schema.FieldType;
import io.leoplatform.sdk.changes.DomainQuery;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OracleDomainQuery
implements DomainQuery {
    private static final Logger log = LoggerFactory.getLogger(OracleDomainQuery.class);
    private final Config oracleConfig;

    @Inject
    public OracleDomainQuery(Config oracleConfig) {
        this.oracleConfig = oracleConfig;
    }

    public String generateSql(String source, List<Field> values) {
        String id = this.tableId(values);
        List<String> queryValues = this.queryValues(values);
        return this.customSql(source, id, queryValues).orElse(this.defaultSql(source, id, queryValues));
    }

    private String tableId(List<Field> values) {
        return values.parallelStream().map(Field::getField).findFirst().orElseThrow(() -> new IllegalArgumentException("Missing field ID"));
    }

    private List<String> queryValues(List<Field> values) {
        if (values.size() > 1000) {
            throw new IllegalArgumentException("Too many values for Oracle IN clause");
        }
        return values.parallelStream().filter(f -> f.getType() == FieldType.STRING).map(Field::getValue).collect(Collectors.toList());
    }

    private Optional<String> customSql(String source, String id, List<String> values) {
        Optional<String> customSql = this.valueForTable(source).map(s -> s.replace("{TABLE}", source)).map(s -> s.replace("{ID}", id)).map(s -> s.replace("{VALUES}", this.valuesClause(values)));
        customSql.ifPresent(s -> log.debug("Custom domain query: {}", s));
        return customSql;
    }

    private Optional<String> valueForTable(String source) {
        try {
            return Optional.of(this.oracleConfig.getString("oracle." + source));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private String defaultSql(String source, String id, List<String> values) {
        String valuesAsString = this.valuesClause(values);
        Optional.ofNullable(source).map(String::trim).filter(s -> !s.isEmpty()).orElseThrow(() -> new IllegalArgumentException("Missing table name"));
        return String.format("SELECT * FROM %s WHERE %s IN (%s)", source, id, valuesAsString);
    }

    private String valuesClause(List<String> values) {
        return values.stream().collect(Collectors.joining("','", "'", "'"));
    }
}

