/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.oracle;

import com.typesafe.config.Config;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import io.leoplatform.schema.ChangeSource;
import io.leoplatform.sdk.ExecutorManager;
import io.leoplatform.sdk.LoadingStream;
import io.leoplatform.sdk.OffloadingStream;
import io.leoplatform.sdk.SDKModule_ProvideBusPayloadWriterFactory;
import io.leoplatform.sdk.SDKModule_ProvideChangeReactorFactory;
import io.leoplatform.sdk.SDKModule_ProvideConnectorConfigFactory;
import io.leoplatform.sdk.SDKModule_ProvideDomainResolverFactory;
import io.leoplatform.sdk.SDKModule_ProvideInternalExecutorManagerFactory;
import io.leoplatform.sdk.SDKModule_ProvideNullLoadingStreamFactory;
import io.leoplatform.sdk.SDKModule_ProvideNullOffloadingStreamFactory;
import io.leoplatform.sdk.changes.ChangeReactor;
import io.leoplatform.sdk.changes.DomainResolver;
import io.leoplatform.sdk.changes.PayloadWriter;
import io.leoplatform.sdk.changes.SchemaChangeQueue;
import io.leoplatform.sdk.config.ConnectorConfig;
import io.leoplatform.sdk.oracle.OracleChangeLoader;
import io.leoplatform.sdk.oracle.OracleChangeRegistrar;
import io.leoplatform.sdk.oracle.OracleChangeSource;
import io.leoplatform.sdk.oracle.OracleChangeWriter;
import io.leoplatform.sdk.oracle.OracleModule_ProvideChangeSourceFactory;
import io.leoplatform.sdk.oracle.OracleModule_ProvideOracleChangeLoaderFactory;
import io.leoplatform.sdk.oracle.OracleModule_ProvideOracleChangeRegistrarFactory;
import io.leoplatform.sdk.oracle.OracleModule_ProvideOracleChangeSourceFactory;
import io.leoplatform.sdk.oracle.OracleModule_ProvideOracleChangeWriterFactory;
import io.leoplatform.sdk.oracle.OracleModule_ProvideOracleConfigFactory;
import io.leoplatform.sdk.oracle.OracleModule_ProvideSchemaChangeQueueFactory;
import io.leoplatform.sdk.oracle.OraclePlatform;
import javax.inject.Provider;

public final class DaggerOraclePlatform
implements OraclePlatform {
    private Provider<ConnectorConfig> provideConnectorConfigProvider;
    private Provider<ExecutorManager> provideInternalExecutorManagerProvider;
    private Provider<LoadingStream> provideNullLoadingStreamProvider;
    private Provider<OffloadingStream> provideNullOffloadingStreamProvider;
    private Provider<DomainResolver> provideDomainResolverProvider;
    private Provider<ChangeReactor> provideChangeReactorProvider;
    private Provider<PayloadWriter> provideBusPayloadWriterProvider;
    private Provider<Config> provideOracleConfigProvider;
    private Provider<ExecutorManager> executorManagerProvider;
    private Provider<SchemaChangeQueue> provideSchemaChangeQueueProvider;
    private Provider<OracleChangeSource> provideOracleChangeSourceProvider;
    private Provider<ChangeSource> provideChangeSourceProvider;
    private Provider<OracleChangeWriter> provideOracleChangeWriterProvider;
    private Provider<OracleChangeRegistrar> provideOracleChangeRegistrarProvider;
    private Provider<OracleChangeLoader> provideOracleChangeLoaderProvider;

    private DaggerOraclePlatform(Builder builder) {
        this.initialize(builder);
    }

    public static OraclePlatform.Builder builder() {
        return new Builder();
    }

    private void initialize(Builder builder) {
        this.provideConnectorConfigProvider = DoubleCheck.provider((Provider)SDKModule_ProvideConnectorConfigFactory.create());
        this.provideInternalExecutorManagerProvider = DoubleCheck.provider((Provider)SDKModule_ProvideInternalExecutorManagerFactory.create(this.provideConnectorConfigProvider));
        this.provideNullLoadingStreamProvider = DoubleCheck.provider((Provider)SDKModule_ProvideNullLoadingStreamFactory.create());
        this.provideNullOffloadingStreamProvider = DoubleCheck.provider((Provider)SDKModule_ProvideNullOffloadingStreamFactory.create());
        this.provideDomainResolverProvider = DoubleCheck.provider((Provider)SDKModule_ProvideDomainResolverFactory.create());
        this.provideChangeReactorProvider = DoubleCheck.provider((Provider)SDKModule_ProvideChangeReactorFactory.create());
        this.provideBusPayloadWriterProvider = DoubleCheck.provider((Provider)SDKModule_ProvideBusPayloadWriterFactory.create(this.provideNullLoadingStreamProvider));
        this.provideOracleConfigProvider = DoubleCheck.provider((Provider)OracleModule_ProvideOracleConfigFactory.create());
        this.executorManagerProvider = InstanceFactory.create((Object)builder.executorManager);
        this.provideSchemaChangeQueueProvider = DoubleCheck.provider((Provider)OracleModule_ProvideSchemaChangeQueueFactory.create(this.provideChangeReactorProvider, this.executorManagerProvider));
        this.provideOracleChangeSourceProvider = DoubleCheck.provider((Provider)OracleModule_ProvideOracleChangeSourceFactory.create(this.provideOracleConfigProvider));
        this.provideChangeSourceProvider = DoubleCheck.provider((Provider)OracleModule_ProvideChangeSourceFactory.create(this.provideOracleConfigProvider));
        this.provideOracleChangeWriterProvider = DoubleCheck.provider((Provider)OracleModule_ProvideOracleChangeWriterFactory.create(this.provideSchemaChangeQueueProvider, this.executorManagerProvider));
        this.provideOracleChangeRegistrarProvider = DoubleCheck.provider((Provider)OracleModule_ProvideOracleChangeRegistrarFactory.create(this.provideOracleChangeSourceProvider, this.provideOracleChangeWriterProvider, this.executorManagerProvider));
        this.provideOracleChangeLoaderProvider = DoubleCheck.provider((Provider)OracleModule_ProvideOracleChangeLoaderFactory.create(this.provideOracleChangeRegistrarProvider));
    }

    public ConnectorConfig connectorConfig() {
        return (ConnectorConfig)this.provideConnectorConfigProvider.get();
    }

    public ExecutorManager executorManager() {
        return (ExecutorManager)this.provideInternalExecutorManagerProvider.get();
    }

    public LoadingStream loadingStream() {
        return (LoadingStream)this.provideNullLoadingStreamProvider.get();
    }

    public OffloadingStream offloadingStream() {
        return (OffloadingStream)this.provideNullOffloadingStreamProvider.get();
    }

    public DomainResolver domainResolver() {
        return (DomainResolver)this.provideDomainResolverProvider.get();
    }

    public ChangeReactor changeReactor() {
        return (ChangeReactor)this.provideChangeReactorProvider.get();
    }

    public PayloadWriter payloadWriter() {
        return (PayloadWriter)this.provideBusPayloadWriterProvider.get();
    }

    @Override
    public Config oracleConfig() {
        return (Config)this.provideOracleConfigProvider.get();
    }

    @Override
    public SchemaChangeQueue changeQueue() {
        return (SchemaChangeQueue)this.provideSchemaChangeQueueProvider.get();
    }

    @Override
    public OracleChangeSource oracleChangeSource() {
        return (OracleChangeSource)this.provideOracleChangeSourceProvider.get();
    }

    @Override
    public ChangeSource changeSource() {
        return (ChangeSource)this.provideChangeSourceProvider.get();
    }

    @Override
    public OracleChangeRegistrar oracleChangeRegistrar() {
        return (OracleChangeRegistrar)this.provideOracleChangeRegistrarProvider.get();
    }

    @Override
    public OracleChangeLoader oracleChangeLoader() {
        return (OracleChangeLoader)this.provideOracleChangeLoaderProvider.get();
    }

    @Override
    public OracleChangeWriter oracleChangeWriter() {
        return (OracleChangeWriter)this.provideOracleChangeWriterProvider.get();
    }

    private static final class Builder
    implements OraclePlatform.Builder {
        private ExecutorManager executorManager;
        private LoadingStream loadingStream;

        private Builder() {
        }

        @Override
        public OraclePlatform build() {
            if (this.executorManager == null) {
                throw new IllegalStateException(ExecutorManager.class.getCanonicalName() + " must be set");
            }
            if (this.loadingStream == null) {
                throw new IllegalStateException(LoadingStream.class.getCanonicalName() + " must be set");
            }
            return new DaggerOraclePlatform(this);
        }

        @Override
        public Builder executorManager(ExecutorManager executorManager) {
            this.executorManager = (ExecutorManager)Preconditions.checkNotNull((Object)executorManager);
            return this;
        }

        @Override
        public Builder loadingStream(LoadingStream stream) {
            this.loadingStream = (LoadingStream)Preconditions.checkNotNull((Object)stream);
            return this;
        }
    }
}

