/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.oracle;

import io.leoplatform.sdk.oracle.OracleChangeDestination;
import io.leoplatform.sdk.oracle.OracleChangeRegistrar;
import io.leoplatform.sdk.oracle.WatchResults;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class OracleChangeLoader {
    private static final Logger log = LoggerFactory.getLogger(OracleChangeLoader.class);
    private final OracleChangeRegistrar registrar;
    private DatabaseChangeRegistration dcr = null;
    private final AtomicBoolean loading = new AtomicBoolean(false);
    private Instant start = null;

    @Inject
    public OracleChangeLoader(OracleChangeRegistrar registrar) {
        this.registrar = registrar;
    }

    public void register(OracleChangeDestination destination) {
        if (!this.loading.getAndSet(true)) {
            this.start = Instant.now();
            this.dcr = this.registrar.create(destination);
            this.loading.set(false);
        }
    }

    public WatchResults deregister() {
        log.info("Stopping Oracle change loader");
        return Optional.ofNullable(this.dcr).map(this.registrar::remove).map(t -> new WatchResults(this.start, Instant.now(), (List<String>)t)).orElse(this.emptyResults());
    }

    public WatchResults end() {
        if (this.loading.getAndSet(false)) {
            return Optional.ofNullable(this.registrar).map(OracleChangeRegistrar::end).map(t -> new WatchResults(this.start, Instant.now(), (List<String>)t)).orElse(this.emptyResults());
        }
        return this.emptyResults();
    }

    private WatchResults emptyResults() {
        Instant now = Instant.now();
        return new WatchResults(now, now, Collections.emptyList());
    }
}

