/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.oracle;

import com.typesafe.config.Config;
import dagger.BindsInstance;
import dagger.Component;
import io.leoplatform.schema.ChangeSource;
import io.leoplatform.sdk.ExecutorManager;
import io.leoplatform.sdk.LoadingStream;
import io.leoplatform.sdk.SDKModule;
import io.leoplatform.sdk.SDKPlatform;
import io.leoplatform.sdk.changes.ChangeReactor;
import io.leoplatform.sdk.changes.DomainQuery;
import io.leoplatform.sdk.changes.DomainResolver;
import io.leoplatform.sdk.changes.PayloadWriter;
import io.leoplatform.sdk.changes.SchemaChangeQueue;
import io.leoplatform.sdk.oracle.DomainObjectModule;
import io.leoplatform.sdk.oracle.OracleChangeLoader;
import io.leoplatform.sdk.oracle.OracleChangeRegistrar;
import io.leoplatform.sdk.oracle.OracleChangeSource;
import io.leoplatform.sdk.oracle.OracleChangeWriter;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
@Component(modules={SDKModule.class, DomainObjectModule.class})
public interface DomainObjectPlatform
extends SDKPlatform {
    public Config oracleConfig();

    public SchemaChangeQueue changeQueue();

    public OracleChangeSource oracleChangeSource();

    public ChangeSource changeSource();

    public OracleChangeRegistrar oracleChangeRegistrar();

    public OracleChangeLoader oracleChangeLoader();

    public OracleChangeWriter oracleChangeWriter();

    public DomainQuery domainQuery();

    @Named(value="DomainObjectResolver")
    public DomainResolver domainResolver();

    @Named(value="DomainObjectReactor")
    public ChangeReactor changeReactor();

    @Component.Builder
    public static interface Builder {
        @BindsInstance
        public Builder executorManager(ExecutorManager var1);

        @BindsInstance
        public Builder loadingStream(LoadingStream var1);

        @BindsInstance
        public Builder payloadWriter(PayloadWriter var1);

        public DomainObjectPlatform build();
    }
}

