/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.oracle;

import io.leoplatform.schema.Field;
import io.leoplatform.sdk.ExecutorManager;
import io.leoplatform.sdk.changes.DomainQuery;
import io.leoplatform.sdk.changes.DomainResolver;
import io.leoplatform.sdk.changes.JsonDomainData;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OracleRowResolver
implements DomainResolver {
    private static final Logger log = LoggerFactory.getLogger(OracleRowResolver.class);
    private static final int BATCH_SIZE = 1000;
    private final DomainQuery domainQuery;
    private final JsonDomainData jsonDomainData;
    private final ExecutorManager manager;

    @Inject
    public OracleRowResolver(DomainQuery domainQuery, JsonDomainData jsonDomainData, ExecutorManager manager) {
        this.domainQuery = domainQuery;
        this.jsonDomainData = jsonDomainData;
        this.manager = manager;
    }

    public JsonArray toResultJson(String sourceName, BlockingQueue<Field> fields) {
        return ((Stream)this.splitAsBatches(fields).parallel()).map(b -> this.domainQuery.generateSql(sourceName, b)).map(this::toJsonAsync).map(CompletableFuture::join).flatMap(Collection::stream).collect(Json::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::addAll).build();
    }

    private CompletableFuture<JsonArray> toJsonAsync(String sql) {
        return CompletableFuture.supplyAsync(() -> this.jsonDomainData.toJson(sql), this.manager.get());
    }

    private Stream<List<Field>> splitAsBatches(BlockingQueue<Field> fields) {
        Stream.Builder batchBuilder = Stream.builder();
        while (!fields.isEmpty()) {
            LinkedList batch = new LinkedList();
            fields.drainTo(batch, 1000);
            batchBuilder.accept(batch);
        }
        return batchBuilder.build();
    }
}

