/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.oracle;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import dagger.Module;
import dagger.Provides;
import io.leoplatform.schema.ChangeSource;
import io.leoplatform.sdk.ExecutorManager;
import io.leoplatform.sdk.changes.AsyncChangeQueue;
import io.leoplatform.sdk.changes.ChangeReactor;
import io.leoplatform.sdk.changes.DomainObjectPayload;
import io.leoplatform.sdk.changes.DomainQuery;
import io.leoplatform.sdk.changes.DomainResolver;
import io.leoplatform.sdk.changes.JsonDomainData;
import io.leoplatform.sdk.changes.PayloadWriter;
import io.leoplatform.sdk.changes.PooledChangeSource;
import io.leoplatform.sdk.changes.SchemaChangeQueue;
import io.leoplatform.sdk.oracle.ConfigFileSource;
import io.leoplatform.sdk.oracle.OracleChangeLoader;
import io.leoplatform.sdk.oracle.OracleChangeRegistrar;
import io.leoplatform.sdk.oracle.OracleChangeSource;
import io.leoplatform.sdk.oracle.OracleChangeWriter;
import io.leoplatform.sdk.oracle.OracleDomainQuery;
import io.leoplatform.sdk.oracle.OracleRowResolver;
import javax.inject.Named;
import javax.inject.Singleton;

@Module
public final class DomainObjectModule {
    @Singleton
    @Provides
    public static OracleChangeSource provideOracleChangeSource(Config oracleConfig) {
        return new ConfigFileSource(oracleConfig);
    }

    @Singleton
    @Provides
    public static ChangeSource provideChangeSource(Config oracleConfig) {
        return new PooledChangeSource(oracleConfig);
    }

    @Singleton
    @Provides
    public static OracleChangeRegistrar provideOracleChangeRegistrar(OracleChangeSource source, OracleChangeWriter ocw, ExecutorManager executorManager) {
        return new OracleChangeRegistrar(source, ocw, executorManager);
    }

    @Singleton
    @Provides
    public static OracleChangeLoader provideOracleChangeLoader(OracleChangeRegistrar registrar) {
        return new OracleChangeLoader(registrar);
    }

    @Singleton
    @Provides
    public static Config provideOracleConfig() {
        return ConfigFactory.load((String)"oracle_config.properties");
    }

    @Singleton
    @Provides
    public static DomainQuery provideDomainQuery(Config oracleConfig) {
        return new OracleDomainQuery(oracleConfig);
    }

    @Singleton
    @Provides
    @Named(value="DomainObjectResolver")
    public static DomainResolver provideDomainObjectResolver(DomainQuery domainQuery, JsonDomainData domainData, ExecutorManager executorManager) {
        return new OracleRowResolver(domainQuery, domainData, executorManager);
    }

    @Singleton
    @Provides
    @Named(value="DomainObjectReactor")
    public static ChangeReactor provideDomainObjectReactor(@Named(value="DomainObjectResolver") DomainResolver domainResolver, PayloadWriter payloadWriter) {
        return new DomainObjectPayload(domainResolver, payloadWriter);
    }

    @Singleton
    @Provides
    public static SchemaChangeQueue provideSchemaChangeQueue(@Named(value="DomainObjectReactor") ChangeReactor changeReactor, ExecutorManager executorManager) {
        return new AsyncChangeQueue(changeReactor, executorManager);
    }
}

