/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.oracle;

import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import io.leoplatform.schema.ChangeSource;
import io.leoplatform.sdk.ExecutorManager;
import io.leoplatform.sdk.LoadingStream;
import io.leoplatform.sdk.OffloadingStream;
import io.leoplatform.sdk.SDKModule_ProvideBusPayloadWriterFactory;
import io.leoplatform.sdk.SDKModule_ProvideConnectorConfigFactory;
import io.leoplatform.sdk.SDKModule_ProvideInternalExecutorManagerFactory;
import io.leoplatform.sdk.SDKModule_ProvideJsonDomainDataFactory;
import io.leoplatform.sdk.SDKModule_ProvideNullLoadingStreamFactory;
import io.leoplatform.sdk.SDKModule_ProvideNullOffloadingStreamFactory;
import io.leoplatform.sdk.changes.ChangeReactor;
import io.leoplatform.sdk.changes.DomainQuery;
import io.leoplatform.sdk.changes.DomainResolver;
import io.leoplatform.sdk.changes.JsonDomainData;
import io.leoplatform.sdk.changes.PayloadWriter;
import io.leoplatform.sdk.changes.SchemaChangeQueue;
import io.leoplatform.sdk.config.ConnectorConfig;
import io.leoplatform.sdk.oracle.DomainObjectModule_ProvideChangeSourceFactory;
import io.leoplatform.sdk.oracle.DomainObjectModule_ProvideDomainObjectReactorFactory;
import io.leoplatform.sdk.oracle.DomainObjectModule_ProvideDomainObjectResolverFactory;
import io.leoplatform.sdk.oracle.DomainObjectModule_ProvideDomainQueryFactory;
import io.leoplatform.sdk.oracle.DomainObjectModule_ProvideOracleChangeLoaderFactory;
import io.leoplatform.sdk.oracle.DomainObjectModule_ProvideOracleChangeRegistrarFactory;
import io.leoplatform.sdk.oracle.DomainObjectModule_ProvideOracleChangeSourceFactory;
import io.leoplatform.sdk.oracle.DomainObjectModule_ProvideSchemaChangeQueueFactory;
import io.leoplatform.sdk.oracle.DomainObjectPlatform;
import io.leoplatform.sdk.oracle.OracleChangeLoader;
import io.leoplatform.sdk.oracle.OracleChangeRegistrar;
import io.leoplatform.sdk.oracle.OracleChangeSource;
import io.leoplatform.sdk.oracle.OracleChangeWriter;
import io.leoplatform.sdk.oracle.OracleChangeWriter_Factory;
import javax.inject.Provider;

public final class DaggerDomainObjectPlatform
implements DomainObjectPlatform {
    private Provider<ConnectorConfig> provideConnectorConfigProvider;
    private Provider<ExecutorManager> provideInternalExecutorManagerProvider;
    private Provider<LoadingStream> provideNullLoadingStreamProvider;
    private Provider<OffloadingStream> provideNullOffloadingStreamProvider;
    private Provider<PayloadWriter> provideBusPayloadWriterProvider;
    private Provider<ChangeSource> provideChangeSourceProvider;
    private Provider<DomainQuery> provideDomainQueryProvider;
    private Provider<JsonDomainData> provideJsonDomainDataProvider;
    private Provider<DomainResolver> provideDomainObjectResolverProvider;
    private Provider<PayloadWriter> payloadWriterProvider;
    private Provider<ChangeReactor> provideDomainObjectReactorProvider;
    private Provider<ExecutorManager> executorManagerProvider;
    private Provider<SchemaChangeQueue> provideSchemaChangeQueueProvider;
    private Provider<OracleChangeWriter> oracleChangeWriterProvider;
    private Provider<OracleChangeSource> provideOracleChangeSourceProvider;
    private Provider<OracleChangeRegistrar> provideOracleChangeRegistrarProvider;
    private Provider<OracleChangeLoader> provideOracleChangeLoaderProvider;

    private DaggerDomainObjectPlatform(Builder builder) {
        this.initialize(builder);
    }

    public static DomainObjectPlatform.Builder builder() {
        return new Builder();
    }

    private void initialize(Builder builder) {
        this.provideConnectorConfigProvider = DoubleCheck.provider((Provider)SDKModule_ProvideConnectorConfigFactory.create());
        this.provideInternalExecutorManagerProvider = DoubleCheck.provider((Provider)SDKModule_ProvideInternalExecutorManagerFactory.create(this.provideConnectorConfigProvider));
        this.provideNullLoadingStreamProvider = DoubleCheck.provider((Provider)SDKModule_ProvideNullLoadingStreamFactory.create());
        this.provideNullOffloadingStreamProvider = DoubleCheck.provider((Provider)SDKModule_ProvideNullOffloadingStreamFactory.create());
        this.provideBusPayloadWriterProvider = DoubleCheck.provider((Provider)SDKModule_ProvideBusPayloadWriterFactory.create(this.provideNullLoadingStreamProvider));
        this.provideChangeSourceProvider = DoubleCheck.provider((Provider)DomainObjectModule_ProvideChangeSourceFactory.create());
        this.provideDomainQueryProvider = DoubleCheck.provider((Provider)DomainObjectModule_ProvideDomainQueryFactory.create());
        this.provideJsonDomainDataProvider = DoubleCheck.provider((Provider)SDKModule_ProvideJsonDomainDataFactory.create());
        this.provideDomainObjectResolverProvider = DoubleCheck.provider((Provider)DomainObjectModule_ProvideDomainObjectResolverFactory.create(this.provideChangeSourceProvider, this.provideDomainQueryProvider, this.provideJsonDomainDataProvider));
        this.payloadWriterProvider = InstanceFactory.create((Object)builder.payloadWriter);
        this.provideDomainObjectReactorProvider = DoubleCheck.provider((Provider)DomainObjectModule_ProvideDomainObjectReactorFactory.create(this.provideDomainObjectResolverProvider, this.payloadWriterProvider));
        this.executorManagerProvider = InstanceFactory.create((Object)builder.executorManager);
        this.provideSchemaChangeQueueProvider = DoubleCheck.provider((Provider)DomainObjectModule_ProvideSchemaChangeQueueFactory.create(this.provideDomainObjectReactorProvider, this.executorManagerProvider));
        this.oracleChangeWriterProvider = DoubleCheck.provider((Provider)OracleChangeWriter_Factory.create(this.provideSchemaChangeQueueProvider, this.executorManagerProvider));
        this.provideOracleChangeSourceProvider = DoubleCheck.provider((Provider)DomainObjectModule_ProvideOracleChangeSourceFactory.create());
        this.provideOracleChangeRegistrarProvider = DoubleCheck.provider((Provider)DomainObjectModule_ProvideOracleChangeRegistrarFactory.create(this.provideOracleChangeSourceProvider, this.oracleChangeWriterProvider, this.executorManagerProvider));
        this.provideOracleChangeLoaderProvider = DoubleCheck.provider((Provider)DomainObjectModule_ProvideOracleChangeLoaderFactory.create(this.provideOracleChangeRegistrarProvider));
    }

    public ConnectorConfig connectorConfig() {
        return (ConnectorConfig)this.provideConnectorConfigProvider.get();
    }

    public ExecutorManager executorManager() {
        return (ExecutorManager)this.provideInternalExecutorManagerProvider.get();
    }

    public LoadingStream loadingStream() {
        return (LoadingStream)this.provideNullLoadingStreamProvider.get();
    }

    public OffloadingStream offloadingStream() {
        return (OffloadingStream)this.provideNullOffloadingStreamProvider.get();
    }

    public PayloadWriter payloadWriter() {
        return (PayloadWriter)this.provideBusPayloadWriterProvider.get();
    }

    @Override
    public OracleChangeWriter oracleChangeWriter() {
        return (OracleChangeWriter)this.oracleChangeWriterProvider.get();
    }

    @Override
    public SchemaChangeQueue changeQueue() {
        return (SchemaChangeQueue)this.provideSchemaChangeQueueProvider.get();
    }

    @Override
    public OracleChangeRegistrar oracleChangeRegistrar() {
        return (OracleChangeRegistrar)this.provideOracleChangeRegistrarProvider.get();
    }

    @Override
    public OracleChangeLoader oracleChangeLoader() {
        return (OracleChangeLoader)this.provideOracleChangeLoaderProvider.get();
    }

    @Override
    public OracleChangeSource oracleChangeSource() {
        return (OracleChangeSource)this.provideOracleChangeSourceProvider.get();
    }

    @Override
    public ChangeSource changeSource() {
        return (ChangeSource)this.provideChangeSourceProvider.get();
    }

    @Override
    public DomainQuery domainQuery() {
        return (DomainQuery)this.provideDomainQueryProvider.get();
    }

    @Override
    public DomainResolver domainResolver() {
        return (DomainResolver)this.provideDomainObjectResolverProvider.get();
    }

    @Override
    public ChangeReactor changeReactor() {
        return (ChangeReactor)this.provideDomainObjectReactorProvider.get();
    }

    private static final class Builder
    implements DomainObjectPlatform.Builder {
        private ExecutorManager executorManager;
        private LoadingStream loadingStream;
        private PayloadWriter payloadWriter;

        private Builder() {
        }

        @Override
        public DomainObjectPlatform build() {
            if (this.executorManager == null) {
                throw new IllegalStateException(ExecutorManager.class.getCanonicalName() + " must be set");
            }
            if (this.loadingStream == null) {
                throw new IllegalStateException(LoadingStream.class.getCanonicalName() + " must be set");
            }
            if (this.payloadWriter == null) {
                throw new IllegalStateException(PayloadWriter.class.getCanonicalName() + " must be set");
            }
            return new DaggerDomainObjectPlatform(this);
        }

        @Override
        public Builder executorManager(ExecutorManager executorManager) {
            this.executorManager = (ExecutorManager)Preconditions.checkNotNull((Object)executorManager);
            return this;
        }

        @Override
        public Builder loadingStream(LoadingStream loadingStream) {
            this.loadingStream = (LoadingStream)Preconditions.checkNotNull((Object)loadingStream);
            return this;
        }

        @Override
        public Builder payloadWriter(PayloadWriter payloadWriter) {
            this.payloadWriter = (PayloadWriter)Preconditions.checkNotNull((Object)payloadWriter);
            return this;
        }
    }
}

