/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.oracle;

import dagger.Module;
import dagger.Provides;
import io.leoplatform.schema.ChangeSource;
import io.leoplatform.sdk.ExecutorManager;
import io.leoplatform.sdk.changes.AsyncChangeQueue;
import io.leoplatform.sdk.changes.ChangeReactor;
import io.leoplatform.sdk.changes.DomainObjectPayload;
import io.leoplatform.sdk.changes.DomainResolver;
import io.leoplatform.sdk.changes.JsonDomainData;
import io.leoplatform.sdk.changes.PayloadWriter;
import io.leoplatform.sdk.changes.PooledChangeSource;
import io.leoplatform.sdk.changes.SchemaChangeQueue;
import io.leoplatform.sdk.oracle.ConfigFileSource;
import io.leoplatform.sdk.oracle.OracleChangeLoader;
import io.leoplatform.sdk.oracle.OracleChangeRegistrar;
import io.leoplatform.sdk.oracle.OracleChangeSource;
import io.leoplatform.sdk.oracle.OracleChangeWriter;
import io.leoplatform.sdk.oracle.OracleRowResolver;
import javax.inject.Named;
import javax.inject.Singleton;

@Module
public final class DomainObjectModule {
    @Singleton
    @Provides
    public static OracleChangeSource provideOracleChangeSource() {
        return new ConfigFileSource();
    }

    @Singleton
    @Provides
    public static ChangeSource provideChangeSource() {
        return new PooledChangeSource();
    }

    @Singleton
    @Provides
    public static OracleChangeRegistrar provideOracleChangeRegistrar(OracleChangeSource source, OracleChangeWriter ocw, ExecutorManager executorManager) {
        return new OracleChangeRegistrar(source, ocw, executorManager);
    }

    @Singleton
    @Provides
    public static OracleChangeLoader provideOracleChangeLoader(OracleChangeRegistrar registrar) {
        return new OracleChangeLoader(registrar);
    }

    @Singleton
    @Provides
    @Named(value="DomainObjectResolver")
    public static DomainResolver provideDomainObjectResolver(ChangeSource source, JsonDomainData domainData) {
        return new OracleRowResolver(source, domainData);
    }

    @Singleton
    @Provides
    @Named(value="DomainObjectReactor")
    public static ChangeReactor provideDomainObjectReactor(@Named(value="DomainObjectResolver") DomainResolver domainResolver, PayloadWriter payloadWriter) {
        return new DomainObjectPayload(domainResolver, payloadWriter);
    }

    @Singleton
    @Provides
    public static SchemaChangeQueue provideSchemaChangeQueue(@Named(value="DomainObjectReactor") ChangeReactor changeReactor, ExecutorManager executorManager) {
        return new AsyncChangeQueue(changeReactor, executorManager);
    }
}

