/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.oracle;

import com.typesafe.config.Config;
import io.leoplatform.sdk.oracle.OracleChangeSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConfigFileSource
implements OracleChangeSource {
    private static final Logger log = LoggerFactory.getLogger(ConfigFileSource.class);
    private static final String COLUMN_SEPARATOR = ",";
    private static final Pattern separatorPattern = Pattern.compile(",", 16);
    private final Config oracleConfig;
    private OracleConnection conn;

    @Inject
    public ConfigFileSource(Config oracleConfig) {
        this.oracleConfig = oracleConfig;
        this.conn = this.getConnection();
    }

    @Override
    public OracleConnection connection() {
        try {
            return this.validConnection();
        }
        catch (Exception e) {
            log.info("Attempting to create connection to Oracle database");
            this.conn = this.getConnection();
            return this.validConnection();
        }
    }

    public List<String> tables() {
        String tableStr = Optional.of(this.oracleConfig).map(c -> c.getString("oracle.tables")).orElseThrow(() -> new IllegalStateException("Missing oracle.tables key in oracle_config.properties"));
        return separatorPattern.splitAsStream(tableStr).map(String::trim).filter(t -> !t.isEmpty()).collect(Collectors.toList());
    }

    public void end() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            log.warn("Unable to close connection", (Throwable)e);
        }
    }

    private OracleConnection getConnection() {
        OracleDriver dr = new OracleDriver();
        Properties props = new Properties();
        props.setProperty("user", this.oracleConfig.getString("oracle.user"));
        props.setProperty("password", this.oracleConfig.getString("oracle.pass"));
        try {
            String url = this.oracleConfig.getString("oracle.url");
            Connection conn = dr.connect(url, props);
            log.info("Established connection to {}", (Object)url);
            return Optional.ofNullable(conn).map(OracleConnection.class::cast).filter(OracleConnection::isUsable).orElseThrow(() -> new IllegalStateException("Unable to connect to database"));
        }
        catch (SQLException s) {
            throw new IllegalStateException("Fatal database error", s);
        }
    }

    private OracleConnection validConnection() {
        return Optional.of(this.conn).filter(OracleConnection::isUsable).filter(this::canPing).orElseThrow(() -> new IllegalStateException("Missing or invalid Oracle database connection"));
    }

    private boolean canPing(OracleConnection c) {
        try {
            return c.pingDatabase() == 0;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cannot ping database", e);
        }
    }
}

