/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.oracle;

import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import io.leoplatform.sdk.ExecutorManager;
import io.leoplatform.sdk.LoadingStream;
import io.leoplatform.sdk.SDKModule_ProvideConnectorConfigFactory;
import io.leoplatform.sdk.SDKModule_ProvideExecutorManagerFactory;
import io.leoplatform.sdk.config.ConnectorConfig;
import io.leoplatform.sdk.oracle.OracleChangeLoader;
import io.leoplatform.sdk.oracle.OracleChangeRegistrar;
import io.leoplatform.sdk.oracle.OracleChangeSource;
import io.leoplatform.sdk.oracle.OracleChangeWriter;
import io.leoplatform.sdk.oracle.OracleModule_ProvideDatabaseChangeListenerFactory;
import io.leoplatform.sdk.oracle.OracleModule_ProvideOracleChangeLoaderFactory;
import io.leoplatform.sdk.oracle.OracleModule_ProvideOracleChangeRegistrarFactory;
import io.leoplatform.sdk.oracle.OraclePlatform;
import javax.inject.Provider;

public final class DaggerOraclePlatform
implements OraclePlatform {
    private Provider<ConnectorConfig> provideConnectorConfigProvider;
    private Provider<ExecutorManager> provideExecutorManagerProvider;
    private Provider<OracleChangeSource> changeSourceProvider;
    private Provider<LoadingStream> loadingStreamProvider;
    private Provider<ExecutorManager> executorManagerProvider;
    private Provider<OracleChangeWriter> provideDatabaseChangeListenerProvider;
    private Provider<OracleChangeRegistrar> provideOracleChangeRegistrarProvider;
    private Provider<OracleChangeLoader> provideOracleChangeLoaderProvider;

    private DaggerOraclePlatform(Builder builder) {
        this.initialize(builder);
    }

    public static OraclePlatform.Builder builder() {
        return new Builder();
    }

    private void initialize(Builder builder) {
        this.provideConnectorConfigProvider = DoubleCheck.provider((Provider)SDKModule_ProvideConnectorConfigFactory.create());
        this.provideExecutorManagerProvider = DoubleCheck.provider((Provider)SDKModule_ProvideExecutorManagerFactory.create(this.provideConnectorConfigProvider));
        this.changeSourceProvider = InstanceFactory.create((Object)builder.changeSource);
        this.loadingStreamProvider = InstanceFactory.create((Object)builder.loadingStream);
        this.executorManagerProvider = InstanceFactory.create((Object)builder.executorManager);
        this.provideDatabaseChangeListenerProvider = DoubleCheck.provider((Provider)OracleModule_ProvideDatabaseChangeListenerFactory.create(this.loadingStreamProvider, this.executorManagerProvider));
        this.provideOracleChangeRegistrarProvider = DoubleCheck.provider((Provider)OracleModule_ProvideOracleChangeRegistrarFactory.create(this.changeSourceProvider, this.provideDatabaseChangeListenerProvider, this.executorManagerProvider));
        this.provideOracleChangeLoaderProvider = DoubleCheck.provider((Provider)OracleModule_ProvideOracleChangeLoaderFactory.create(this.provideOracleChangeRegistrarProvider));
    }

    public ConnectorConfig connectorConfig() {
        return (ConnectorConfig)this.provideConnectorConfigProvider.get();
    }

    public ExecutorManager executorManager() {
        return (ExecutorManager)this.provideExecutorManagerProvider.get();
    }

    @Override
    public OracleChangeRegistrar oracleChangeRegistrar() {
        return (OracleChangeRegistrar)this.provideOracleChangeRegistrarProvider.get();
    }

    @Override
    public OracleChangeLoader oracleChangeLoader() {
        return (OracleChangeLoader)this.provideOracleChangeLoaderProvider.get();
    }

    @Override
    public OracleChangeWriter databaseChangeListener() {
        return (OracleChangeWriter)this.provideDatabaseChangeListenerProvider.get();
    }

    private static final class Builder
    implements OraclePlatform.Builder {
        private ExecutorManager executorManager;
        private LoadingStream loadingStream;
        private OracleChangeSource changeSource;

        private Builder() {
        }

        @Override
        public OraclePlatform build() {
            if (this.executorManager == null) {
                throw new IllegalStateException(ExecutorManager.class.getCanonicalName() + " must be set");
            }
            if (this.loadingStream == null) {
                throw new IllegalStateException(LoadingStream.class.getCanonicalName() + " must be set");
            }
            if (this.changeSource == null) {
                throw new IllegalStateException(OracleChangeSource.class.getCanonicalName() + " must be set");
            }
            return new DaggerOraclePlatform(this);
        }

        @Override
        public Builder executorManager(ExecutorManager executorManager) {
            this.executorManager = (ExecutorManager)Preconditions.checkNotNull((Object)executorManager);
            return this;
        }

        @Override
        public Builder loadingStream(LoadingStream stream) {
            this.loadingStream = (LoadingStream)Preconditions.checkNotNull((Object)stream);
            return this;
        }

        @Override
        public Builder changeSource(OracleChangeSource source) {
            this.changeSource = (OracleChangeSource)Preconditions.checkNotNull((Object)source);
            return this;
        }
    }
}

