/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.oracle;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import io.leoplatform.sdk.oracle.OracleChangeSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;

public class ConfigFileSource
implements OracleChangeSource {
    private static final String COLUMN_SEPARATOR = ",";
    private static final Pattern separatorPattern = Pattern.compile(",", 16);
    private static final Config cfg = ConfigFactory.load((String)"oracle_config.properties");

    @Override
    public OracleConnection connection() {
        OracleDriver dr = new OracleDriver();
        Properties props = new Properties();
        props.setProperty("user", cfg.getString("oracle.user"));
        props.setProperty("password", cfg.getString("oracle.pass"));
        try {
            Connection conn = dr.connect(cfg.getString("oracle.url"), props);
            return Optional.ofNullable(conn).map(OracleConnection.class::cast).orElseThrow(() -> new IllegalStateException("Unable to connect to database"));
        }
        catch (SQLException s) {
            throw new IllegalStateException("Fatal database error", s);
        }
    }

    public List<String> tables() {
        String tableStr = Optional.of(cfg).map(c -> c.getString("oracle.tables")).orElseThrow(() -> new IllegalStateException("Missing oracle.tables key in oracle_config.properties"));
        return separatorPattern.splitAsStream(tableStr).map(String::trim).filter(t -> !t.isEmpty()).collect(Collectors.toList());
    }
}

