/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.aws;

import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import io.leoplatform.sdk.ExecutorManager;
import io.leoplatform.sdk.LoadingStream;
import io.leoplatform.sdk.OffloadingStream;
import io.leoplatform.sdk.SDKModule_ProvideBusPayloadWriterFactory;
import io.leoplatform.sdk.SDKModule_ProvideChangeReactorFactory;
import io.leoplatform.sdk.SDKModule_ProvideConnectorConfigFactory;
import io.leoplatform.sdk.SDKModule_ProvideDomainResolverFactory;
import io.leoplatform.sdk.SDKModule_ProvideInternalExecutorManagerFactory;
import io.leoplatform.sdk.SDKModule_ProvideNullLoadingStreamFactory;
import io.leoplatform.sdk.SDKModule_ProvideNullOffloadingStreamFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideKinesisResultsFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideKinesisWriteFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideThresholdMonitorFactory;
import io.leoplatform.sdk.aws.AWSPlatform;
import io.leoplatform.sdk.aws.kinesis.KinesisProducerWriter;
import io.leoplatform.sdk.aws.kinesis.KinesisResults;
import io.leoplatform.sdk.changes.ChangeReactor;
import io.leoplatform.sdk.changes.DomainResolver;
import io.leoplatform.sdk.changes.PayloadWriter;
import io.leoplatform.sdk.config.ConnectorConfig;
import io.leoplatform.sdk.payload.ThresholdMonitor;
import javax.inject.Provider;

public final class DaggerAWSPlatform
implements AWSPlatform {
    private Provider<ConnectorConfig> provideConnectorConfigProvider;
    private Provider<ExecutorManager> provideInternalExecutorManagerProvider;
    private Provider<LoadingStream> provideNullLoadingStreamProvider;
    private Provider<OffloadingStream> provideNullOffloadingStreamProvider;
    private Provider<DomainResolver> provideDomainResolverProvider;
    private Provider<ChangeReactor> provideChangeReactorProvider;
    private Provider<PayloadWriter> provideBusPayloadWriterProvider;
    private Provider<ExecutorManager> executorManagerProvider;
    private Provider<ThresholdMonitor> provideThresholdMonitorProvider;
    private Provider<KinesisResults> provideKinesisResultsProvider;
    private Provider<KinesisProducerWriter> provideKinesisWriteProvider;

    private DaggerAWSPlatform(Builder builder) {
        this.initialize(builder);
    }

    public static AWSPlatform.Builder builder() {
        return new Builder();
    }

    private void initialize(Builder builder) {
        this.provideConnectorConfigProvider = DoubleCheck.provider((Provider)SDKModule_ProvideConnectorConfigFactory.create());
        this.provideInternalExecutorManagerProvider = DoubleCheck.provider((Provider)SDKModule_ProvideInternalExecutorManagerFactory.create(this.provideConnectorConfigProvider));
        this.provideNullLoadingStreamProvider = DoubleCheck.provider((Provider)SDKModule_ProvideNullLoadingStreamFactory.create());
        this.provideNullOffloadingStreamProvider = DoubleCheck.provider((Provider)SDKModule_ProvideNullOffloadingStreamFactory.create());
        this.provideDomainResolverProvider = DoubleCheck.provider((Provider)SDKModule_ProvideDomainResolverFactory.create());
        this.provideChangeReactorProvider = DoubleCheck.provider((Provider)SDKModule_ProvideChangeReactorFactory.create());
        this.provideBusPayloadWriterProvider = DoubleCheck.provider((Provider)SDKModule_ProvideBusPayloadWriterFactory.create(this.provideNullLoadingStreamProvider));
        this.executorManagerProvider = InstanceFactory.create((Object)builder.executorManager);
        this.provideThresholdMonitorProvider = DoubleCheck.provider((Provider)AWSModule_ProvideThresholdMonitorFactory.create(this.provideConnectorConfigProvider, this.executorManagerProvider));
        this.provideKinesisResultsProvider = DoubleCheck.provider((Provider)AWSModule_ProvideKinesisResultsFactory.create(this.provideThresholdMonitorProvider));
        this.provideKinesisWriteProvider = DoubleCheck.provider((Provider)AWSModule_ProvideKinesisWriteFactory.create(this.provideConnectorConfigProvider, this.executorManagerProvider, this.provideKinesisResultsProvider));
    }

    public ConnectorConfig connectorConfig() {
        return (ConnectorConfig)this.provideConnectorConfigProvider.get();
    }

    public ExecutorManager executorManager() {
        return (ExecutorManager)this.provideInternalExecutorManagerProvider.get();
    }

    public LoadingStream loadingStream() {
        return (LoadingStream)this.provideNullLoadingStreamProvider.get();
    }

    public OffloadingStream offloadingStream() {
        return (OffloadingStream)this.provideNullOffloadingStreamProvider.get();
    }

    public DomainResolver domainResolver() {
        return (DomainResolver)this.provideDomainResolverProvider.get();
    }

    public ChangeReactor changeReactor() {
        return (ChangeReactor)this.provideChangeReactorProvider.get();
    }

    public PayloadWriter payloadWriter() {
        return (PayloadWriter)this.provideBusPayloadWriterProvider.get();
    }

    @Override
    public ThresholdMonitor thresholdMonitor() {
        return (ThresholdMonitor)this.provideThresholdMonitorProvider.get();
    }

    @Override
    public KinesisProducerWriter kinesisWrite() {
        return (KinesisProducerWriter)this.provideKinesisWriteProvider.get();
    }

    @Override
    public KinesisResults kinesisResults() {
        return (KinesisResults)this.provideKinesisResultsProvider.get();
    }

    private static final class Builder
    implements AWSPlatform.Builder {
        private ExecutorManager executorManager;
        private LoadingStream loadingStream;
        private PayloadWriter payloadWriter;

        private Builder() {
        }

        @Override
        public AWSPlatform build() {
            if (this.executorManager == null) {
                throw new IllegalStateException(ExecutorManager.class.getCanonicalName() + " must be set");
            }
            if (this.loadingStream == null) {
                throw new IllegalStateException(LoadingStream.class.getCanonicalName() + " must be set");
            }
            if (this.payloadWriter == null) {
                throw new IllegalStateException(PayloadWriter.class.getCanonicalName() + " must be set");
            }
            return new DaggerAWSPlatform(this);
        }

        @Override
        public Builder executorManager(ExecutorManager executorManager) {
            this.executorManager = (ExecutorManager)Preconditions.checkNotNull((Object)executorManager);
            return this;
        }

        @Override
        public Builder loadingStream(LoadingStream executor) {
            this.loadingStream = (LoadingStream)Preconditions.checkNotNull((Object)executor);
            return this;
        }

        @Override
        public Builder payloadWriter(PayloadWriter executor2) {
            this.payloadWriter = (PayloadWriter)Preconditions.checkNotNull((Object)executor2);
            return this;
        }
    }
}

