/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.aws;

import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import io.leoplatform.sdk.ExecutorManager;
import io.leoplatform.sdk.LoadingStream;
import io.leoplatform.sdk.OffloadingStream;
import io.leoplatform.sdk.SDKModule_ProvideBusPayloadWriterFactory;
import io.leoplatform.sdk.SDKModule_ProvideChangeReactorFactory;
import io.leoplatform.sdk.SDKModule_ProvideConnectorConfigFactory;
import io.leoplatform.sdk.SDKModule_ProvideDomainResolverFactory;
import io.leoplatform.sdk.SDKModule_ProvideInternalExecutorManagerFactory;
import io.leoplatform.sdk.SDKModule_ProvideNullLoadingStreamFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideKinesisResultsFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideKinesisWriteFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideOffloadingStreamFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideThresholdMonitorFactory;
import io.leoplatform.sdk.aws.AWSOffloadingPlatform;
import io.leoplatform.sdk.aws.kinesis.KinesisProducerWriter;
import io.leoplatform.sdk.aws.kinesis.KinesisResults;
import io.leoplatform.sdk.bus.OffloadingBot;
import io.leoplatform.sdk.changes.ChangeReactor;
import io.leoplatform.sdk.changes.DomainResolver;
import io.leoplatform.sdk.changes.PayloadWriter;
import io.leoplatform.sdk.config.ConnectorConfig;
import io.leoplatform.sdk.payload.ThresholdMonitor;
import javax.inject.Provider;

public final class DaggerAWSOffloadingPlatform
implements AWSOffloadingPlatform {
    private Provider<ConnectorConfig> provideConnectorConfigProvider;
    private Provider<ExecutorManager> provideInternalExecutorManagerProvider;
    private Provider<LoadingStream> provideNullLoadingStreamProvider;
    private Provider<DomainResolver> provideDomainResolverProvider;
    private Provider<ChangeReactor> provideChangeReactorProvider;
    private Provider<PayloadWriter> provideBusPayloadWriterProvider;
    private Provider<ExecutorManager> executorManagerProvider;
    private Provider<ThresholdMonitor> provideThresholdMonitorProvider;
    private Provider<KinesisResults> provideKinesisResultsProvider;
    private Provider<KinesisProducerWriter> provideKinesisWriteProvider;
    private Provider<OffloadingStream> provideOffloadingStreamProvider;

    private DaggerAWSOffloadingPlatform(Builder builder) {
        this.initialize(builder);
    }

    public static AWSOffloadingPlatform.Builder builder() {
        return new Builder();
    }

    private void initialize(Builder builder) {
        this.provideConnectorConfigProvider = DoubleCheck.provider((Provider)SDKModule_ProvideConnectorConfigFactory.create());
        this.provideInternalExecutorManagerProvider = DoubleCheck.provider((Provider)SDKModule_ProvideInternalExecutorManagerFactory.create(this.provideConnectorConfigProvider));
        this.provideNullLoadingStreamProvider = DoubleCheck.provider((Provider)SDKModule_ProvideNullLoadingStreamFactory.create());
        this.provideDomainResolverProvider = DoubleCheck.provider((Provider)SDKModule_ProvideDomainResolverFactory.create());
        this.provideChangeReactorProvider = DoubleCheck.provider((Provider)SDKModule_ProvideChangeReactorFactory.create());
        this.provideBusPayloadWriterProvider = DoubleCheck.provider((Provider)SDKModule_ProvideBusPayloadWriterFactory.create(this.provideNullLoadingStreamProvider));
        this.executorManagerProvider = InstanceFactory.create((Object)builder.executorManager);
        this.provideThresholdMonitorProvider = DoubleCheck.provider((Provider)AWSModule_ProvideThresholdMonitorFactory.create(this.provideConnectorConfigProvider, this.executorManagerProvider));
        this.provideKinesisResultsProvider = DoubleCheck.provider((Provider)AWSModule_ProvideKinesisResultsFactory.create(this.provideThresholdMonitorProvider));
        this.provideKinesisWriteProvider = DoubleCheck.provider((Provider)AWSModule_ProvideKinesisWriteFactory.create(this.provideConnectorConfigProvider, this.executorManagerProvider, this.provideKinesisResultsProvider));
        this.provideOffloadingStreamProvider = DoubleCheck.provider((Provider)AWSModule_ProvideOffloadingStreamFactory.create(this.executorManagerProvider));
    }

    public ConnectorConfig connectorConfig() {
        return (ConnectorConfig)this.provideConnectorConfigProvider.get();
    }

    public ExecutorManager executorManager() {
        return (ExecutorManager)this.provideInternalExecutorManagerProvider.get();
    }

    public LoadingStream loadingStream() {
        return (LoadingStream)this.provideNullLoadingStreamProvider.get();
    }

    public DomainResolver domainResolver() {
        return (DomainResolver)this.provideDomainResolverProvider.get();
    }

    public ChangeReactor changeReactor() {
        return (ChangeReactor)this.provideChangeReactorProvider.get();
    }

    public PayloadWriter payloadWriter() {
        return (PayloadWriter)this.provideBusPayloadWriterProvider.get();
    }

    @Override
    public ThresholdMonitor thresholdMonitor() {
        return (ThresholdMonitor)this.provideThresholdMonitorProvider.get();
    }

    @Override
    public KinesisProducerWriter kinesisWrite() {
        return (KinesisProducerWriter)this.provideKinesisWriteProvider.get();
    }

    @Override
    public KinesisResults kinesisResults() {
        return (KinesisResults)this.provideKinesisResultsProvider.get();
    }

    @Override
    public OffloadingStream offloadingStream() {
        return (OffloadingStream)this.provideOffloadingStreamProvider.get();
    }

    private static final class Builder
    implements AWSOffloadingPlatform.Builder {
        private ExecutorManager executorManager;
        private OffloadingBot offloadingBot;

        private Builder() {
        }

        @Override
        public AWSOffloadingPlatform build() {
            if (this.executorManager == null) {
                throw new IllegalStateException(ExecutorManager.class.getCanonicalName() + " must be set");
            }
            if (this.offloadingBot == null) {
                throw new IllegalStateException(OffloadingBot.class.getCanonicalName() + " must be set");
            }
            return new DaggerAWSOffloadingPlatform(this);
        }

        @Override
        public Builder executorManager(ExecutorManager executorManager) {
            this.executorManager = (ExecutorManager)Preconditions.checkNotNull((Object)executorManager);
            return this;
        }

        @Override
        public Builder offloadingBot(OffloadingBot offloadingBot) {
            this.offloadingBot = (OffloadingBot)Preconditions.checkNotNull((Object)offloadingBot);
            return this;
        }
    }
}

