/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.aws.s3;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import io.leoplatform.sdk.aws.s3.PendingS3Upload;
import io.leoplatform.sdk.aws.s3.S3LocationPayload;
import io.leoplatform.sdk.aws.s3.S3Payload;
import io.leoplatform.sdk.payload.FileSegment;
import io.leoplatform.sdk.payload.StorageEventOffset;
import io.leoplatform.sdk.payload.StorageStats;
import io.leoplatform.sdk.payload.StorageUnits;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

class PendingFileUpload
implements PendingS3Upload {
    private final String fileName;
    private final Path cachedFile;
    private final Queue<StorageEventOffset> storageEventOffsets;

    PendingFileUpload(String fileName, Queue<FileSegment> segments) {
        this.fileName = fileName;
        this.storageEventOffsets = segments.stream().map(FileSegment::getOffset).collect(Collectors.toCollection(LinkedList::new));
        this.cachedFile = this.toTempFile(segments);
    }

    @Override
    public String filename() {
        return this.fileName;
    }

    @Override
    public PutObjectRequest s3PutRequest(String name) {
        try {
            ObjectMetadata meta = new ObjectMetadata();
            long fileSize = Files.size(this.cachedFile);
            meta.setContentLength(fileSize);
            try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(this.cachedFile, new OpenOption[0]), 512);){
                byte[] resultByte = DigestUtils.md5((InputStream)is);
                String streamMD5 = new String(Base64.encodeBase64((byte[])resultByte));
                meta.setContentMD5(streamMD5);
            }
            is = new BufferedInputStream(Files.newInputStream(this.cachedFile, StandardOpenOption.DELETE_ON_CLOSE), 512);
            return new PutObjectRequest(name, this.fileName, (InputStream)is, meta);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read S3 temporary file", e);
        }
    }

    @Override
    public S3Payload s3Payload(UploadResult result, String botName) {
        String queue = this.getEvent();
        Long gzipSize = this.storageEventOffsets.stream().mapToLong(StorageEventOffset::getGzipSize).sum();
        Long size = this.storageEventOffsets.stream().mapToLong(StorageEventOffset::getSize).sum();
        Long records = this.storageEventOffsets.stream().mapToLong(StorageEventOffset::getRecords).sum();
        S3LocationPayload location = new S3LocationPayload(result.getBucketName(), result.getKey());
        List<StorageEventOffset> offsets = this.accumulateOffsets();
        StorageStats stats = new StorageStats(Collections.singletonMap(botName, new StorageUnits(records)));
        return new S3Payload(queue, null, null, location, offsets, gzipSize, size, records, stats);
    }

    private String getEvent() {
        return Optional.of(this.storageEventOffsets).map(Queue::peek).map(StorageEventOffset::getEvent).orElseThrow(() -> new IllegalArgumentException("Missing storage event"));
    }

    private List<StorageEventOffset> accumulateOffsets() {
        AtomicLong startAccumulator = new AtomicLong();
        AtomicLong offsetAccumulator = new AtomicLong();
        AtomicLong gzipOffsetAccumulator = new AtomicLong();
        return this.storageEventOffsets.stream().map(o -> {
            Long start = startAccumulator.getAndAdd(o.getRecords());
            Long end = start + o.getRecords() - 1L;
            Long offset = offsetAccumulator.getAndAdd(o.getSize());
            Long gzipOffset = gzipOffsetAccumulator.getAndAdd(o.getGzipSize());
            return new StorageEventOffset(o.getEvent(), start, end, o.getSize(), offset, o.getRecords(), o.getGzipSize(), gzipOffset);
        }).collect(Collectors.toList());
    }

    private Path toTempFile(Queue<FileSegment> segments) {
        try {
            Path tempFile = Files.createTempFile("java-sdk-", ".gz", new FileAttribute[0]);
            try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(tempFile, new OpenOption[0]), 512);){
                FileSegment fs;
                while ((fs = segments.poll()) != null) {
                    ((OutputStream)os).write(fs.getSegment());
                }
                ((OutputStream)os).flush();
            }
            return tempFile;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create temporary file");
        }
    }
}

