/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.aws.payload;

import io.leoplatform.sdk.aws.payload.CompressionWriter;
import io.leoplatform.sdk.aws.payload.S3JsonPayload;
import io.leoplatform.sdk.aws.s3.S3Payload;
import io.leoplatform.sdk.payload.EntityPayload;
import io.leoplatform.sdk.payload.EventPayload;
import io.leoplatform.sdk.payload.FileSegment;
import io.leoplatform.sdk.payload.StorageEventOffset;
import io.leoplatform.sdk.payload.ThresholdMonitor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class JSDKGzipWriter
implements CompressionWriter {
    private static final Logger log = LoggerFactory.getLogger(JSDKGzipWriter.class);
    private static final String NEWLINE = "\n";
    private final S3JsonPayload streamJson;
    private final ThresholdMonitor thresholdMonitor;

    @Inject
    public JSDKGzipWriter(S3JsonPayload streamJson, ThresholdMonitor thresholdMonitor) {
        this.streamJson = streamJson;
        this.thresholdMonitor = thresholdMonitor;
    }

    @Override
    public FileSegment compressWithOffsets(Collection<EventPayload> payloads) {
        List<EntityPayload> entities = this.toEntityPayloads(payloads);
        String inflatedPayload = this.inflatedPayload(entities);
        byte[] compressedPayload = this.toGzip(inflatedPayload);
        String queue = this.getQueue(entities);
        Long start = 0L;
        Long records = entities.size();
        Long end = records - 1L;
        Long size = inflatedPayload.getBytes(StandardCharsets.UTF_8).length;
        Long offset = 0L;
        Long gzipSize = compressedPayload.length;
        Long gzipOffset = 0L;
        this.thresholdMonitor.addBytes(gzipSize);
        StorageEventOffset seo = new StorageEventOffset(queue, start, end, size, offset, records, gzipSize, gzipOffset);
        return new FileSegment(seo, compressedPayload);
    }

    @Override
    public ByteBuffer compress(S3Payload payload) {
        String inflatedPayload = this.streamJson.toJsonString(payload) + NEWLINE;
        byte[] compressedPayload = this.toGzip(inflatedPayload);
        this.thresholdMonitor.addBytes(Long.valueOf(compressedPayload.length));
        return ByteBuffer.wrap(compressedPayload);
    }

    private String inflatedPayload(List<EntityPayload> entities) {
        return entities.parallelStream().map(arg_0 -> ((S3JsonPayload)this.streamJson).toJsonString(arg_0)).collect(Collectors.joining(NEWLINE, "", NEWLINE));
    }

    private String getQueue(List<EntityPayload> entities) {
        return entities.stream().map(EntityPayload::getEvent).filter(Objects::nonNull).findAny().orElseThrow(() -> new IllegalArgumentException("No queue found in payload"));
    }

    private List<EntityPayload> toEntityPayloads(Collection<EventPayload> payloads) {
        return this.validate(payloads).stream().map(arg_0 -> ((S3JsonPayload)this.streamJson).toEntity(arg_0)).collect(Collectors.toList());
    }

    private Collection<EventPayload> validate(Collection<EventPayload> payloads) {
        return Optional.ofNullable(payloads).filter(p -> !p.isEmpty()).orElseThrow(() -> new IllegalArgumentException("Missing payload"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] toGzip(String json) {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream(512);){
            this.toStream(json, byteStream);
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not serialize compressed payload", e);
        }
    }

    private void toStream(String json, ByteArrayOutputStream byteStream) {
        try (GZIPOutputStream os = new GZIPOutputStream((OutputStream)byteStream, true);){
            ((OutputStream)os).write(json.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not compress payload", e);
        }
    }
}

