/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.aws.s3;

import io.leoplatform.sdk.aws.s3.S3LocationPayload;
import io.leoplatform.sdk.payload.StorageEventOffset;
import io.leoplatform.sdk.payload.StoragePayload;
import io.leoplatform.sdk.payload.StorageStats;
import io.leoplatform.sdk.payload.StreamCorrelation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class S3Payload
implements StoragePayload {
    private final String event;
    private final String start;
    private final String end;
    private final S3LocationPayload s3;
    private final List<StorageEventOffset> offsets;
    private final Long gzipSize;
    private final Long size;
    private final Long records;
    private final StorageStats stats;
    private final List<StreamCorrelation> correlations = Collections.emptyList();

    public S3Payload(String event, String start, String end, S3LocationPayload s3, List<StorageEventOffset> offsets, Long gzipSize, Long size, Long records, StorageStats stats) {
        this.event = event;
        this.start = start;
        this.end = end;
        this.s3 = s3;
        this.offsets = offsets;
        this.gzipSize = gzipSize;
        this.size = size;
        this.records = records;
        this.stats = stats;
    }

    public String getEvent() {
        return this.event;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public S3LocationPayload getS3() {
        return this.s3;
    }

    public List<StorageEventOffset> getOffsets() {
        return this.offsets;
    }

    public Long getGzipSize() {
        return this.gzipSize;
    }

    public Long getSize() {
        return this.size;
    }

    public Long getRecords() {
        return this.records;
    }

    public StorageStats getStats() {
        return this.stats;
    }

    public List<StreamCorrelation> getCorrelations() {
        return this.correlations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3Payload s3Payload = (S3Payload)o;
        return Objects.equals(this.event, s3Payload.event) && Objects.equals(this.start, s3Payload.start) && Objects.equals(this.end, s3Payload.end) && Objects.equals(this.s3, s3Payload.s3) && Objects.equals(this.offsets, s3Payload.offsets) && Objects.equals(this.gzipSize, s3Payload.gzipSize) && Objects.equals(this.size, s3Payload.size) && Objects.equals(this.records, s3Payload.records);
    }

    public int hashCode() {
        return Objects.hash(this.event, this.start, this.end, this.s3, this.offsets, this.gzipSize, this.size, this.records);
    }

    public String toString() {
        return String.format("S3Payload{event='%s', start=%s, end=%s, s3=%s, offsets=%s, gzipSize=%d, size=%d, records=%d}", this.event, this.start, this.end, this.s3, this.offsets, this.gzipSize, this.size, this.records);
    }
}

