/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.aws.s3;

import com.amazonaws.services.s3.transfer.model.UploadResult;
import io.leoplatform.sdk.aws.kinesis.KinesisProducerWriter;
import io.leoplatform.sdk.aws.payload.CompressionWriter;
import io.leoplatform.sdk.aws.s3.S3Payload;
import io.leoplatform.sdk.payload.ThresholdMonitor;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class S3Results {
    private static final Logger log = LoggerFactory.getLogger(S3Results.class);
    private final AtomicLong successes = new AtomicLong();
    private final AtomicLong failures = new AtomicLong();
    private final Instant start = Instant.now();
    private final CompressionWriter compressionWriter;
    private final KinesisProducerWriter kinesis;
    private final ThresholdMonitor thresholdMonitor;

    @Inject
    public S3Results(CompressionWriter compressionWriter, KinesisProducerWriter kinesis, ThresholdMonitor thresholdMonitor) {
        this.compressionWriter = compressionWriter;
        this.kinesis = kinesis;
        this.thresholdMonitor = thresholdMonitor;
    }

    void addSuccess(S3Payload payload, UploadResult result) {
        this.successes.incrementAndGet();
        this.logSuccess(payload.getRecords(), result);
        this.thresholdMonitor.addBytes(payload.getGzipSize());
        ByteBuffer b = this.compressionWriter.compress(payload);
        this.kinesis.write(b);
    }

    Long successes() {
        return this.successes.get();
    }

    void addFailure(String desc, Exception ex) {
        this.failures.incrementAndGet();
        log.error("Could not upload {} to S3: {}", (Object)desc, (Object)ex);
    }

    Long failures() {
        return this.failures.get();
    }

    Instant start() {
        return this.start;
    }

    private void logSuccess(Long records, UploadResult result) {
        String key = Optional.ofNullable(result).map(UploadResult::getKey).orElse("Unknown");
        log.info("Creating Kinesis pointer to {} for {} records", (Object)key, (Object)records);
    }
}

