/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.aws.payload;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr353.JSR353Module;
import io.leoplatform.sdk.aws.payload.S3JsonPayload;
import io.leoplatform.sdk.aws.s3.S3Payload;
import io.leoplatform.sdk.bus.LoadingBot;
import io.leoplatform.sdk.payload.EntityPayload;
import io.leoplatform.sdk.payload.EventPayload;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class JacksonPayload
implements S3JsonPayload {
    private final ObjectMapper mapper = JacksonPayload.buildMapper();
    private final LoadingBot bot;

    @Inject
    public JacksonPayload(LoadingBot bot) {
        this.bot = bot;
    }

    public String toJsonString(EventPayload eventPayload) {
        EntityPayload entityPayload = new EntityPayload(eventPayload, this.bot);
        return this.toJsonString(entityPayload);
    }

    public String toJsonString(EntityPayload entityPayload) {
        try {
            return this.mapper.writeValueAsString((Object)entityPayload);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create JSON payload");
        }
    }

    @Override
    public String toJsonString(S3Payload s3Payload) {
        try {
            return this.mapper.writeValueAsString((Object)s3Payload);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create S3 JSON payload");
        }
    }

    public EntityPayload toEntity(EventPayload eventPayload) {
        return Optional.ofNullable(eventPayload).map(p -> new EntityPayload(p, this.bot)).orElseThrow(() -> new IllegalArgumentException("Invalid event payload"));
    }

    private static ObjectMapper buildMapper() {
        return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.ALWAYS).registerModule((Module)new JSR353Module());
    }
}

