/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk;

import io.leoplatform.sdk.DaggerExternalExecutorPlatform;
import io.leoplatform.sdk.DaggerSDKPlatform;
import io.leoplatform.sdk.ExternalExecutorPlatform;
import io.leoplatform.sdk.LoadingStream;
import io.leoplatform.sdk.OffloadingStream;
import io.leoplatform.sdk.SDKPlatform;
import io.leoplatform.sdk.aws.DaggerAWSLoadingPlatform;
import io.leoplatform.sdk.aws.DaggerAWSOffloadingPlatform;
import io.leoplatform.sdk.bus.Bots;
import io.leoplatform.sdk.bus.LoadingBot;
import io.leoplatform.sdk.bus.OffloadingBot;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LeoAWS {
    private static final Logger log = LoggerFactory.getLogger(LeoAWS.class);

    public static LoadingStream of(LoadingBot bot, Executor executor) {
        ExternalExecutorPlatform sdkPlatform = DaggerExternalExecutorPlatform.builder().executor(executor).build();
        LoadingStream stream = LeoAWS.getLoadingStream(bot, (SDKPlatform)sdkPlatform);
        log.info("Created loading stream to {} queue with supplied executor", (Object)bot.destination().name());
        return stream;
    }

    public static LoadingStream of(LoadingBot bot) {
        SDKPlatform sdkPlatform = DaggerSDKPlatform.builder().build();
        LoadingStream stream = LeoAWS.getLoadingStream(bot, sdkPlatform);
        log.info("Created loading stream to {} queue with default executor", (Object)bot.destination().name());
        return stream;
    }

    public static OffloadingStream of(OffloadingBot bot) {
        SDKPlatform sdkPlatform = DaggerSDKPlatform.builder().build();
        OffloadingStream stream = LeoAWS.getOffloadingStream(bot, sdkPlatform);
        log.info("Created offloading stream from {} queue with default executor", (Object)bot.source().name());
        return stream;
    }

    public static OffloadingStream of(OffloadingBot bot, Executor executor) {
        ExternalExecutorPlatform sdkPlatform = DaggerExternalExecutorPlatform.builder().executor(executor).build();
        OffloadingStream stream = LeoAWS.getOffloadingStream(bot, (SDKPlatform)sdkPlatform);
        log.info("Created offloading stream from {} queue with default executor", (Object)bot.source().name());
        return stream;
    }

    private static LoadingStream getLoadingStream(LoadingBot bot, SDKPlatform sdkPlatform) {
        return DaggerAWSLoadingPlatform.builder().executorManager(sdkPlatform.executorManager()).loadingBot(bot).build().loadingStream();
    }

    private static OffloadingStream getOffloadingStream(OffloadingBot bot, SDKPlatform sdkPlatform) {
        return DaggerAWSOffloadingPlatform.builder().executorManager(sdkPlatform.executorManager()).offloadingBot(bot).build().offloadingStream();
    }

    public static LoadingStream ofChanges() {
        return LeoAWS.of(Bots.ofChanges());
    }

    public static LoadingStream ofChanges(Executor executor) {
        return LeoAWS.of(Bots.ofChanges(), executor);
    }
}

