/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.aws;

import dagger.BindsInstance;
import dagger.Component;
import io.leoplatform.sdk.AsyncWorkQueue;
import io.leoplatform.sdk.ExecutorManager;
import io.leoplatform.sdk.LoadingStream;
import io.leoplatform.sdk.SDKModule;
import io.leoplatform.sdk.aws.AWSModule;
import io.leoplatform.sdk.aws.AWSPlatform;
import io.leoplatform.sdk.aws.WorkQueues;
import io.leoplatform.sdk.aws.payload.CompressionWriter;
import io.leoplatform.sdk.aws.payload.S3JsonPayload;
import io.leoplatform.sdk.aws.s3.S3Results;
import io.leoplatform.sdk.aws.s3.S3TransferManager;
import io.leoplatform.sdk.aws.s3.S3Writer;
import io.leoplatform.sdk.bus.LoadingBot;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
@Component(modules={AWSModule.class, SDKModule.class})
public interface AWSLoadingPlatform
extends AWSPlatform {
    @Named(value="AwsLoadingStream")
    public LoadingStream loadingStream();

    public WorkQueues workQueues();

    @Named(value="Proxy")
    public AsyncWorkQueue transferProxy();

    @Named(value="Stream")
    public AsyncWorkQueue kinesisQueue();

    @Named(value="Storage")
    public AsyncWorkQueue s3Queue();

    public CompressionWriter kinesisCompression();

    public S3JsonPayload s3JsonPayload();

    public S3TransferManager s3TransferManager();

    public S3Writer s3Writer();

    public S3Results s3Results();

    @Component.Builder
    public static interface Builder {
        @BindsInstance
        public Builder executorManager(ExecutorManager var1);

        @BindsInstance
        public Builder loadingBot(LoadingBot var1);

        public AWSLoadingPlatform build();
    }
}

